/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Model;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

class ArithmeticDecoder {
    private final Model model;
    private long low;
    private long high;
    private long value;
    private final InputStream in;

    public ArithmeticDecoder(Model model, InputStream in) throws IOException {
        Preconditions.checkNotNull((Object)model, (Object)"model is null");
        Preconditions.checkNotNull((Object)in, (Object)"in is null");
        this.model = model;
        this.in = in;
        for (int i = 0; i < 6; ++i) {
            this.bufferByte();
        }
    }

    public ArithmeticDecoder(Model model, byte[] bytes) throws IOException {
        this(model, new ByteArrayInputStream((byte[])Preconditions.checkNotNull((Object)bytes, (Object)"bytes is null")));
    }

    public int decode() throws IOException {
        long range = this.high - this.low + 1L >>> this.model.log2MaxCount();
        int currentSymbolCount = (int)((this.value - this.low) / range);
        Model.SymbolInfo symbolInfo = this.model.countToSymbol(currentSymbolCount);
        this.high = this.low + range * (long)symbolInfo.highCount() - 1L;
        this.low += range * (long)symbolInfo.lowCount();
        while ((this.high & 0xFF0000000000L) == (this.low & 0xFF0000000000L)) {
            this.bufferByte();
        }
        if ((this.high >> 32) - (this.low >> 32) == 1L) {
            while ((this.high & 0xFF00000000L) == 0L && (this.low & 0xFF00000000L) == 0xFF00000000L) {
                this.low = ArithmeticDecoder.removeUnderflowByte(this.low);
                this.high = ArithmeticDecoder.removeUnderflowByte(this.high);
                this.value = ArithmeticDecoder.removeUnderflowByte(this.value);
                this.bufferByte();
            }
        }
        this.low &= 0xFFFFFFFFFFFFL;
        this.high &= 0xFFFFFFFFFFFFL;
        this.value &= 0xFFFFFFFFFFFFL;
        return symbolInfo.symbol();
    }

    private void bufferByte() throws IOException {
        this.low <<= 8;
        this.high = this.high << 8 | 0xFFL;
        int nextByte = this.in.read();
        if (nextByte < 0) {
            this.value <<= 8;
        } else {
            this.value <<= 8;
            this.value |= (long)nextByte;
        }
    }

    public static long removeUnderflowByte(long value) {
        long highBits = (value & 0xFF0000000000L) >>> 8;
        long lowBits = value & 0xFFFFFFFFL;
        long newValue = highBits | lowBits;
        return newValue;
    }
}

