/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Model;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

class ArithmeticEncoder {
    private final Model model;
    private final OutputStream out;
    private long low;
    private long high = 0xFFFFFFFFFFFFL;
    private int underflowHighValue;
    private int underflowBytes;

    public ArithmeticEncoder(Model model, OutputStream out) {
        Preconditions.checkNotNull((Object)model, (Object)"model is null");
        Preconditions.checkNotNull((Object)out, (Object)"out is null");
        this.model = model;
        this.out = out;
    }

    public void encode(int symbol) throws IOException {
        Model.SymbolInfo symbolInfo = this.model.getSymbolInfo(symbol);
        long range = this.high - this.low + 1L >> this.model.log2MaxCount();
        this.high = this.low + range * (long)symbolInfo.highCount() - 1L;
        this.low += range * (long)symbolInfo.lowCount();
        while ((this.high & 0xFF0000000000L) == (this.low & 0xFF0000000000L)) {
            int underflowValue;
            int value = (int)(this.high >>> 40);
            this.out.write(value);
            int n = underflowValue = value == this.underflowHighValue ? 0 : 255;
            while (this.underflowBytes > 0) {
                this.out.write(underflowValue);
                --this.underflowBytes;
            }
            this.low <<= 8;
            this.high = this.high << 8 | 0xFFL;
        }
        this.low &= 0xFFFFFFFFFFFFL;
        this.high &= 0xFFFFFFFFFFFFL;
        if ((this.high >> 32) - (this.low >> 32) == 1L) {
            while ((this.high & 0xFF00000000L) == 0L && (this.low & 0xFF00000000L) == 0xFF00000000L) {
                if (this.underflowBytes == 0) {
                    this.underflowHighValue = (int)(this.high >>> 40);
                }
                ++this.underflowBytes;
                this.low = ArithmeticEncoder.removeUnderflowByte(this.low, 0);
                this.high = ArithmeticEncoder.removeUnderflowByte(this.high, 255);
            }
        }
    }

    public void close() throws IOException {
        if (this.underflowBytes == 0) {
            this.out.write((int)(this.low >>> 40) + 1);
        } else if ((this.low & 0xFF00000000L) == 0xFF00000000L) {
            this.out.write((int)(this.high >>> 40));
        } else {
            this.out.write((int)(this.low >>> 40));
            while (this.underflowBytes > 0) {
                this.out.write(255);
                --this.underflowBytes;
            }
            int secondByte = (int)(this.low >>> 32 & 0xFFL);
            this.out.write(secondByte + 1);
        }
    }

    public static long removeUnderflowByte(long value, int backFillValue) {
        long highBits = value & 0xFF0000000000L;
        long lowBits = (value & 0xFFFFFFFFL) << 8;
        long newValue = highBits | lowBits | (long)backFillValue;
        return newValue;
    }
}

