/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Numbers;
import com.google.common.base.Preconditions;

public class BucketAndHash {
    private final int bucket;
    private final long hash;

    BucketAndHash(int bucket, long hash) {
        this.bucket = bucket;
        this.hash = hash;
    }

    public static BucketAndHash fromHash(long hash, int numberOfBuckets) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(numberOfBuckets), (Object)"numberOfBuckets must be a power of 2");
        int bucketMask = numberOfBuckets - 1;
        int bucket = (int)(hash & (long)bucketMask);
        hash |= Long.MIN_VALUE;
        int bits = Integer.numberOfTrailingZeros(numberOfBuckets);
        return new BucketAndHash(bucket, hash >>= bits);
    }

    public int getBucket() {
        return this.bucket;
    }

    public long getHash() {
        return this.hash;
    }
}

