/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.BucketAndHash;
import com.facebook.stats.cardinality.HyperLogLogUtil;
import com.facebook.stats.cardinality.Numbers;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class HyperLogLog {
    private final byte[] buckets;
    private double currentSum;
    private int nonZeroBuckets = 0;

    public HyperLogLog(int numberOfBuckets) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(numberOfBuckets), (Object)"numberOfBuckets must be a power of 2");
        Preconditions.checkArgument((numberOfBuckets > 0 ? 1 : 0) != 0, (Object)"numberOfBuckets must be > 0");
        this.buckets = new byte[numberOfBuckets];
        this.currentSum = this.buckets.length;
    }

    public HyperLogLog(int[] buckets) {
        this(buckets.length);
        this.currentSum = 0.0;
        for (int i = 0; i < buckets.length; ++i) {
            int value = buckets[i];
            Preconditions.checkArgument((value >= 0 && value <= 127 ? 1 : 0) != 0, (String)"values must be > 0 and <= %s, found %s", (int)127, (int)value);
            this.buckets[i] = (byte)value;
            this.currentSum += 1.0 / (double)(1 << value);
            if (value == 0) continue;
            ++this.nonZeroBuckets;
        }
    }

    public void add(long value) {
        BucketAndHash bucketAndHash = BucketAndHash.fromHash(HyperLogLogUtil.computeHash(value), this.buckets.length);
        int bucket = bucketAndHash.getBucket();
        int lowestBitPosition = Long.numberOfTrailingZeros(bucketAndHash.getHash()) + 1;
        byte previous = this.buckets[bucket];
        if (previous == 0) {
            ++this.nonZeroBuckets;
        }
        if (lowestBitPosition > previous) {
            this.currentSum -= 1.0 / (double)(1L << previous);
            this.currentSum += 1.0 / (double)(1L << lowestBitPosition);
            this.buckets[bucket] = (byte)lowestBitPosition;
        }
    }

    public long estimate() {
        int zeroBuckets;
        double alpha = HyperLogLogUtil.computeAlpha(this.buckets.length);
        double result = alpha * (double)this.buckets.length * (double)this.buckets.length / this.currentSum;
        if (result <= 2.5 * (double)this.buckets.length && (zeroBuckets = this.buckets.length - this.nonZeroBuckets) > 0) {
            result = (double)this.buckets.length * Math.log((double)this.buckets.length * 1.0 / (double)zeroBuckets);
        }
        return Math.round(result);
    }

    public int[] buckets() {
        int[] result = new int[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            result[i] = this.buckets[i];
        }
        return result;
    }
}

