/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.AdaptiveHyperLogLog;
import com.facebook.stats.cardinality.ArithmeticDecoder;
import com.facebook.stats.cardinality.ArithmeticEncoder;
import com.facebook.stats.cardinality.HyperLogLog;
import com.facebook.stats.cardinality.Model;
import com.facebook.stats.cardinality.SortedStaticModel;
import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HyperLogLogCodec {
    public void encodeHyperLogLog(HyperLogLog hyperLogLog, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)hyperLogLog, (Object)"hyperLogLog is null");
        this.encodeHyperLogLog(hyperLogLog, new DataOutputStream(out));
    }

    public void encodeHyperLogLog(HyperLogLog hyperLogLog, DataOutputStream out) throws IOException {
        this.encodeBuckets(out, hyperLogLog.buckets(), hyperLogLog.estimate());
    }

    public void encodeAdaptiveHyperLogLog(AdaptiveHyperLogLog hyperLogLog, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)hyperLogLog, (Object)"hyperLogLog is null");
        this.encodeAdaptiveHyperLogLog(hyperLogLog, new DataOutputStream(out));
    }

    public void encodeAdaptiveHyperLogLog(AdaptiveHyperLogLog hyperLogLog, DataOutputStream out) throws IOException {
        this.encodeBuckets(out, hyperLogLog.buckets(), hyperLogLog.estimate());
    }

    public void encodeBuckets(DataOutputStream out, int[] buckets, float estimate) throws IOException {
        int numberOfBuckets = buckets.length;
        Preconditions.checkArgument((numberOfBuckets > 0 ? 1 : 0) != 0, (Object)"buckets is empty");
        Preconditions.checkArgument((boolean)HyperLogLogCodec.isPowerOf2(numberOfBuckets), (Object)"numberOfBuckets must be a power of 2");
        int maxValue = buckets[0];
        for (int value : buckets) {
            if (value <= maxValue) continue;
            maxValue = value;
        }
        maxValue = HyperLogLogCodec.nextPowerOf2(maxValue);
        int estimateFloatBits = Float.floatToIntBits(estimate);
        out.writeInt(estimateFloatBits);
        estimate = Float.intBitsToFloat(estimateFloatBits);
        int log2Buckets = Integer.numberOfTrailingZeros(numberOfBuckets);
        int log2MaxValue = Integer.numberOfTrailingZeros(maxValue);
        byte bucketsAndMaxValue = (byte)(log2Buckets << 4 | log2MaxValue);
        out.write(bucketsAndMaxValue);
        SortedStaticModel hyperLogLogModel = HyperLogLogCodec.createHyperLogLogSymbolModel((long)estimate, numberOfBuckets, (byte)maxValue);
        ArithmeticEncoder encoder = new ArithmeticEncoder(hyperLogLogModel, out);
        for (int symbol : buckets) {
            encoder.encode(symbol);
        }
        encoder.close();
    }

    public HyperLogLog decodeHyperLogLog(InputStream in) throws IOException {
        return this.decodeHyperLogLog(new DataInputStream(in));
    }

    public HyperLogLog decodeHyperLogLog(DataInputStream in) throws IOException {
        int[] buckets = this.decodeBuckets(in);
        return new HyperLogLog(buckets);
    }

    public AdaptiveHyperLogLog decodeAdaptiveHyperLogLog(InputStream in) throws IOException {
        return this.decodeAdaptiveHyperLogLog(new DataInputStream(in));
    }

    public AdaptiveHyperLogLog decodeAdaptiveHyperLogLog(DataInputStream in) throws IOException {
        int[] buckets = this.decodeBuckets(in);
        return new AdaptiveHyperLogLog(buckets);
    }

    private int[] decodeBuckets(DataInputStream in) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"in is null");
        int estimateFloatBits = in.readInt();
        float estimate = Float.intBitsToFloat(estimateFloatBits);
        byte bucketsAndMaxValue = in.readByte();
        int log2NumberOfBuckets = bucketsAndMaxValue >> 4 & 0xF;
        int numberOfBuckets = 1 << log2NumberOfBuckets;
        int log2MaxValue = bucketsAndMaxValue & 0xF;
        byte maxValue = (byte)(1 << log2MaxValue);
        SortedStaticModel hyperLogLogModel = HyperLogLogCodec.createHyperLogLogSymbolModel((long)estimate, numberOfBuckets, maxValue);
        int[] buckets = new int[numberOfBuckets];
        ArithmeticDecoder decoder = new ArithmeticDecoder((Model)hyperLogLogModel, in);
        for (int index = 0; index < buckets.length; ++index) {
            buckets[index] = decoder.decode();
        }
        return buckets;
    }

    public static SortedStaticModel createHyperLogLogSymbolModel(long estimate, int bucketCount, byte maxValue) {
        double[] probability = HyperLogLogCodec.hyperLogLogProbabilities(estimate, bucketCount, maxValue);
        return new SortedStaticModel(probability);
    }

    public static double[] hyperLogLogProbabilities(long cardinality, int bucketCount, byte maxValue) {
        double[] probabilities = new double[maxValue + 1];
        double lastCumulativeProbability = 0.0;
        for (int value = 0; value < maxValue; ++value) {
            double cumulativeProbability = HyperLogLogCodec.probabilityRegisterLessThan(cardinality, bucketCount, value);
            probabilities[value] = cumulativeProbability - lastCumulativeProbability;
            lastCumulativeProbability = cumulativeProbability;
        }
        return probabilities;
    }

    public static double probabilityRegisterLessThan(long cardinality, int bucketCount, int value) {
        return StrictMath.pow(1.0 - 1.0 / ((double)(1 << value) * 1.0 * (double)bucketCount), cardinality);
    }

    private static byte nextPowerOf2(int value) {
        int newValue = Integer.highestOneBit(value);
        if (newValue < value) {
            newValue <<= 1;
        }
        if (newValue == 0) {
            ++newValue;
        }
        return (byte)newValue;
    }

    private static boolean isPowerOf2(int numberOfBuckets) {
        return (numberOfBuckets & numberOfBuckets - 1) == 0;
    }
}

