/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Model;
import com.facebook.stats.cardinality.StaticModelUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class SortedStaticModel
implements Model {
    private final int[] symbolToIndex;
    private final int[] indexToSymbol;
    private final int[] countsByIndex;
    private final int totalIndex;

    public SortedStaticModel(double[] weights) {
        Preconditions.checkNotNull((Object)weights, (Object)"weights is null");
        Preconditions.checkArgument((weights.length > 1 ? 1 : 0) != 0, (Object)"weights is empty");
        Preconditions.checkArgument((weights.length <= 512 ? 1 : 0) != 0, (Object)"weights is can not have more than 512 entries");
        this.symbolToIndex = new int[weights.length + 1];
        this.indexToSymbol = new int[weights.length + 1];
        this.countsByIndex = new int[weights.length + 1];
        this.totalIndex = weights.length;
        double[] probabilities = StaticModelUtil.weightsToProbabilities(weights, 10);
        List<SymbolProbability> symbolProbabilities = this.sortProbabilities(probabilities);
        int symbolIndex = 0;
        for (SymbolProbability symbolProbability : symbolProbabilities) {
            int symbol = symbolProbability.symbol;
            double probability = symbolProbability.probability;
            this.symbolToIndex[symbol] = symbolIndex;
            this.indexToSymbol[symbolIndex] = symbol;
            int value = this.countsByIndex[symbolIndex] + (int)(4096.0 * probability);
            value = Math.min(value, 4096 - (probabilities.length - symbolIndex));
            this.countsByIndex[symbolIndex + 1] = value = Math.max(value, this.countsByIndex[symbolIndex] + 1);
            if (this.countsByIndex[symbolIndex + 1] <= this.countsByIndex[symbolIndex]) {
                Preconditions.checkState((this.countsByIndex[symbolIndex + 1] > this.countsByIndex[symbolIndex] ? 1 : 0) != 0, (String)"Internal error: symbol %s high value %s is not greater than the low value %s", (Object)symbol, (Object)this.countsByIndex[symbolIndex + 1], (Object)this.countsByIndex[symbolIndex]);
            }
            ++symbolIndex;
        }
        Preconditions.checkState((this.countsByIndex[this.totalIndex - 1] < 4096 ? 1 : 0) != 0, (Object)"Internal error: model max value %s must be less than %s");
        this.symbolToIndex[this.totalIndex] = -1;
        this.countsByIndex[this.totalIndex] = 4096;
        for (int i = 1; i < this.countsByIndex.length; ++i) {
            Preconditions.checkState((this.countsByIndex[i - 1] < this.countsByIndex[i] ? 1 : 0) != 0, (Object)"Internal error: model is invalid");
        }
    }

    @Override
    public Model.SymbolInfo getSymbolInfo(int symbol) {
        Preconditions.checkPositionIndex((int)symbol, (int)this.symbolToIndex.length, (String)"symbol");
        int symbolIndex = this.symbolToIndex[symbol];
        return new Model.SymbolInfo(symbol, this.countsByIndex[symbolIndex], this.countsByIndex[symbolIndex + 1]);
    }

    @Override
    public int log2MaxCount() {
        return 12;
    }

    @Override
    public Model.SymbolInfo countToSymbol(int targetCount) {
        Preconditions.checkArgument((targetCount >= 0 ? 1 : 0) != 0, (String)"targetCount is negative %s", (int)targetCount);
        for (int symbolIndex = 0; symbolIndex < this.countsByIndex.length; ++symbolIndex) {
            int count = this.countsByIndex[symbolIndex + 1];
            if (targetCount >= count) continue;
            return new Model.SymbolInfo(this.indexToSymbol[symbolIndex], this.countsByIndex[symbolIndex], this.countsByIndex[symbolIndex + 1]);
        }
        throw new IllegalArgumentException("invalid target count " + targetCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedStaticModel staticModel = (SortedStaticModel)o;
        if (this.totalIndex != staticModel.totalIndex) {
            return false;
        }
        return Arrays.equals(this.countsByIndex, staticModel.countsByIndex);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.countsByIndex);
        result = 31 * result + this.totalIndex;
        return result;
    }

    private List<SymbolProbability> sortProbabilities(double[] probabilities) {
        ArrayList<SymbolProbability> symbolProbabilities = new ArrayList<SymbolProbability>();
        for (int symbol = 0; symbol < probabilities.length; ++symbol) {
            symbolProbabilities.add(new SymbolProbability(symbol, probabilities[symbol]));
        }
        Collections.sort(symbolProbabilities);
        return symbolProbabilities;
    }

    private static class SymbolProbability
    implements Comparable<SymbolProbability> {
        private final int symbol;
        private final double probability;

        private SymbolProbability(int symbol, double probability) {
            this.symbol = symbol;
            this.probability = probability;
        }

        @Override
        public int compareTo(SymbolProbability o) {
            return ComparisonChain.start().compare(o.probability, this.probability).compare(this.symbol, o.symbol).result();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SymbolProbability");
            sb.append("{symbol=").append(this.symbol);
            sb.append(", probability=").append(this.probability);
            sb.append('}');
            return sb.toString();
        }
    }
}

