/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Model;
import com.facebook.stats.cardinality.StaticModelUtil;
import com.google.common.base.Preconditions;
import java.util.Arrays;

class StaticModel
implements Model {
    private final int[] counts;
    private final int totalIndex;

    public StaticModel(double[] weights) {
        Preconditions.checkNotNull((Object)weights, (Object)"weights is null");
        Preconditions.checkArgument((weights.length > 1 ? 1 : 0) != 0, (Object)"weights is empty");
        Preconditions.checkArgument((weights.length <= 512 ? 1 : 0) != 0, (Object)"weights is can not have more than 512 entries");
        this.counts = new int[weights.length + 1];
        this.totalIndex = weights.length;
        double[] probabilities = StaticModelUtil.weightsToProbabilities(weights, 10);
        for (int symbol = 0; symbol < probabilities.length; ++symbol) {
            double probability = probabilities[symbol];
            int value = this.counts[symbol] + (int)(4096.0 * probability);
            value = Math.min(value, 4096 - (probabilities.length - symbol));
            this.counts[symbol + 1] = value = Math.max(value, this.counts[symbol] + 1);
            if (this.counts[symbol + 1] > this.counts[symbol]) continue;
            Preconditions.checkState((this.counts[symbol + 1] > this.counts[symbol] ? 1 : 0) != 0, (String)"Internal error: symbol %s high value %s is not greater than the low value %s", (Object)symbol, (Object)this.counts[symbol + 1], (Object)this.counts[symbol]);
        }
        Preconditions.checkState((this.counts[this.totalIndex - 1] < 4096 ? 1 : 0) != 0, (Object)"Internal error: model max value %s must be less than %s");
        this.counts[this.totalIndex] = 4096;
        for (int i = 1; i < this.counts.length; ++i) {
            Preconditions.checkState((this.counts[i - 1] < this.counts[i] ? 1 : 0) != 0, (Object)"Internal error: model is invalid");
        }
    }

    @Override
    public Model.SymbolInfo getSymbolInfo(int symbol) {
        Preconditions.checkPositionIndex((int)symbol, (int)this.counts.length, (String)"symbol");
        return new Model.SymbolInfo(symbol, this.counts[symbol], this.counts[symbol + 1]);
    }

    @Override
    public int log2MaxCount() {
        return 12;
    }

    @Override
    public Model.SymbolInfo countToSymbol(int targetCount) {
        Preconditions.checkArgument((targetCount >= 0 ? 1 : 0) != 0, (String)"targetCount is negative %s", (int)targetCount);
        int lowSymbol = 0;
        int highSymbol = this.counts.length;
        while (highSymbol > lowSymbol + 1) {
            int midSymbol = lowSymbol + highSymbol >>> 1;
            if (this.counts[midSymbol] > targetCount) {
                highSymbol = midSymbol;
                continue;
            }
            lowSymbol = midSymbol;
        }
        return new Model.SymbolInfo(lowSymbol, this.counts[lowSymbol], this.counts[lowSymbol + 1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticModel staticModel = (StaticModel)o;
        if (this.totalIndex != staticModel.totalIndex) {
            return false;
        }
        return Arrays.equals(this.counts, staticModel.counts);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.counts);
        result = 31 * result + this.totalIndex;
        return result;
    }
}

