/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.google.common.base.Preconditions;
import java.util.Arrays;

final class StaticModelUtil {
    public static final int COUNT_BITS = 12;
    public static final int MAX_COUNT = 4096;
    public static final double SMALLEST_PROBABILITY = 2.5E-4;

    private StaticModelUtil() {
    }

    public static double[] weightsToProbabilities(double[] weights) {
        return StaticModelUtil.weightsToProbabilities(weights, Integer.MAX_VALUE);
    }

    public static double[] weightsToProbabilities(double[] weights, int iterationLimit) {
        Preconditions.checkNotNull((Object)weights, (Object)"weights is null");
        Preconditions.checkArgument((weights.length > 0 ? 1 : 0) != 0, (Object)"weights is empty");
        return StaticModelUtil.weightsToProbabilities(Arrays.copyOf(weights, weights.length), StaticModelUtil.sum(weights), iterationLimit);
    }

    private static strictfp double[] weightsToProbabilities(double[] weights, double sum, int iterationLimit) {
        int iterationCount = 0;
        do {
            for (int i = 0; i < weights.length; ++i) {
                Preconditions.checkArgument((weights[i] >= 0.0 ? 1 : 0) != 0, (Object)String.format("weight %s value %s is not greater than zero", i, weights[i]));
                int n = i;
                weights[n] = weights[n] / sum;
                if (weights[i] < 2.5E-4) {
                    weights[i] = 2.5E-4;
                    continue;
                }
                if (!(weights[i] > 0.999)) continue;
                weights[i] = 0.999;
            }
        } while (((sum = StaticModelUtil.sum(weights)) < 0.9999 || sum > 1.0001) && ++iterationCount < iterationLimit);
        return weights;
    }

    private static strictfp double sum(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum;
    }
}

