/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.topk;

import com.facebook.stats.topk.TopK;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class HashBasedTopK<T extends Comparable<T>>
implements TopK<T> {
    private final int k;
    private final Map<T, Long> counts;

    public HashBasedTopK(int k) {
        this.k = k;
        this.counts = new HashMap<T, Long>(k);
    }

    @Override
    public synchronized void add(T key, long count) {
        Preconditions.checkNotNull(key, (Object)"key can't be null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"count to add must be non-negative, got %s", (long)count);
        Long currentCount = this.counts.get(key);
        if (currentCount == null) {
            currentCount = 0L;
        }
        this.counts.put(key, currentCount + count);
    }

    @Override
    public synchronized List<T> getTopK() {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T key1, T key2) {
                return Longs.compare((long)((Long)HashBasedTopK.this.counts.get(key1)), (long)((Long)HashBasedTopK.this.counts.get(key2)));
            }
        };
        PriorityQueue<T> topK = new PriorityQueue<T>(this.k, comparator);
        for (Map.Entry<T, Long> entry : this.counts.entrySet()) {
            if (topK.size() < this.k) {
                topK.offer(entry.getKey());
                continue;
            }
            if (entry.getValue() <= this.counts.get(topK.peek())) continue;
            topK.offer(entry.getKey());
            topK.poll();
        }
        LinkedList sortedTopK = new LinkedList();
        while (!topK.isEmpty()) {
            sortedTopK.addFirst(topK.poll());
        }
        return sortedTopK;
    }
}

