/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing;

import com.facebook.collections.Factory;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class LoopInputStream
extends InputStream {
    private final Factory<InputStream> streamFactory;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final AtomicInteger loopCount = new AtomicInteger(0);
    private volatile InputStream inputStream;

    public LoopInputStream(Factory<InputStream> streamFactory) {
        this.streamFactory = streamFactory;
        this.nextLoop();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.stop.get()) {
            return -1;
        }
        int c;
        while ((c = this.inputStream.read()) == -1) {
            this.nextLoop();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextLoop() {
        this.inputStream = (InputStream)this.streamFactory.create();
        AtomicInteger atomicInteger = this.loopCount;
        synchronized (atomicInteger) {
            this.loopCount.incrementAndGet();
            this.loopCount.notifyAll();
        }
    }

    public void stop() {
        this.stop.set(true);
    }

    public int getLoopCount() {
        return this.loopCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoopCount(int count) throws InterruptedException {
        while (this.loopCount.get() < count) {
            AtomicInteger atomicInteger = this.loopCount;
            synchronized (atomicInteger) {
                this.loopCount.wait(1000L);
            }
        }
    }
}

