/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing;

import com.facebook.testing.AnnotatedRunnable;
import com.facebook.testing.MockScheduledFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MockExecutor
implements ScheduledExecutorService {
    private final List<AnnotatedRunnable> runnableList = Collections.synchronizedList(new ArrayList());
    private final CountDownLatch latch = new CountDownLatch(1);
    private final IdentityHashMap<ScheduledFuture<?>, ScheduledFuture<?>> outstandingTasks = new IdentityHashMap();
    private volatile boolean rejectSubmission = false;
    private volatile boolean isShutdown = false;
    private volatile boolean isTerminated = false;

    public List<AnnotatedRunnable> getRunnableList() {
        return this.runnableList;
    }

    public void setShutdown(boolean shutdown) {
        this.isShutdown = shutdown;
    }

    public void setTerminated(boolean terminated) {
        this.isTerminated = terminated;
    }

    public void setRejectSubmission(boolean rejectSubmission) {
        this.rejectSubmission = rejectSubmission;
    }

    public void triggerShutdownLatch() {
        this.latch.countDown();
    }

    public AnnotatedRunnable removeHead() {
        return this.runnableList.isEmpty() ? null : this.runnableList.remove(0);
    }

    public int getNumPendingTasks() {
        return this.runnableList.size();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.rejectSubmission) {
            throw new RejectedExecutionException();
        }
        this.runnableList.add(new AnnotatedRunnable(command, delay, delay, unit));
        return new MockScheduledFuture<Void>(this.toCallable(command));
    }

    private <T> Callable toCallable(final Runnable runnable, final T result) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                runnable.run();
                return result;
            }
        };
    }

    private Callable<Void> toCallable(Runnable runnable) {
        return this.toCallable(new AnnotatedRunnable(runnable), null);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.rejectSubmission) {
            throw new RejectedExecutionException();
        }
        MockScheduledFuture<V> future = new MockScheduledFuture<V>(callable);
        AnnotatedRunnable runnable = new AnnotatedRunnable(future, delay, delay, unit);
        runnable.setFuture(future);
        this.runnableList.add(runnable);
        this.outstandingTasks.put(future, future);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.rejectSubmission) {
            throw new RejectedExecutionException();
        }
        AnnotatedRunnable runnable = new AnnotatedRunnable(command, initialDelay, period, unit);
        this.runnableList.add(runnable);
        MockScheduledFuture<Void> future = new MockScheduledFuture<Void>(Executors.callable(runnable, null));
        runnable.setFuture(future);
        this.outstandingTasks.put(future, future);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.rejectSubmission) {
            throw new RejectedExecutionException();
        }
        AnnotatedRunnable runnable = new AnnotatedRunnable(command, initialDelay, delay, unit);
        this.runnableList.add(runnable);
        MockScheduledFuture<Void> future = new MockScheduledFuture<Void>(Executors.callable(runnable, null));
        runnable.setFuture(future);
        this.outstandingTasks.put(future, future);
        return future;
    }

    @Override
    public void shutdown() {
        this.cancelPendingTasks();
        this.isShutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.cancelPendingTasks();
        return new ArrayList<Runnable>(this.runnableList);
    }

    private void cancelPendingTasks() {
        for (Map.Entry<ScheduledFuture<?>, ScheduledFuture<?>> entry : this.outstandingTasks.entrySet()) {
            entry.getValue().cancel(false);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> Future<T> submit(final Callable<T> task) {
        this.runnableList.add(new AnnotatedRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    task.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        return new MockScheduledFuture<T>(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.runnableList.add(new AnnotatedRunnable(task));
        return new MockScheduledFuture(this.toCallable(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.runnableList.add(new AnnotatedRunnable(task));
        return new MockScheduledFuture<Void>(this.toCallable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.SECONDS);
    }

    public void drain() {
        while (this.getNumPendingTasks() > 0) {
            this.removeHead().run();
        }
    }

    public void drain(int maxTasks) {
        for (int i = 0; i < maxTasks && this.getNumPendingTasks() > 0; ++i) {
            this.removeHead().run();
        }
    }
}

