/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockScheduledFuture<V>
implements ScheduledFuture<V>,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MockScheduledFuture.class);
    private final Callable<V> callable;
    private final Object lock = new Object();
    private volatile boolean hasRun = false;
    private volatile boolean isCancelled = false;
    private Exception callableException = null;
    private V result = null;

    public MockScheduledFuture(Callable<V> callable) {
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.result = this.callable.call();
        }
        catch (Exception e) {
            this.callableException = e;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.hasRun = true;
                this.lock.notifyAll();
            }
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return 0L;
    }

    @Override
    public int compareTo(Delayed o) {
        return 0;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.isCancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.hasRun;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LOG.error("should never see this");
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long start = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (!this.hasRun) {
                this.lock.wait(timeoutMillis);
                if (timeoutMillis <= 0L || System.currentTimeMillis() - start < timeoutMillis) continue;
                throw new TimeoutException();
            }
        }
        if (this.callableException != null) {
            throw new ExecutionException(this.callableException);
        }
        return this.result;
    }
}

