/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.testing;

import com.facebook.testing.Function;
import com.google.common.collect.LinkedHashMultimap;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public class TestUtils {
    private TestUtils() {
        throw new AssertionError();
    }

    public static <T> Function<T> noOpFunction() {
        return new Function<T>(){

            @Override
            public void execute(T argument) {
            }
        };
    }

    public static AtomicInteger countCompletedRunnables(int numTasks, Function<Runnable> submissionCallback) {
        final AtomicInteger completed = new AtomicInteger(0);
        for (int i = 0; i < numTasks; ++i) {
            submissionCallback.execute(new Runnable(){

                @Override
                public void run() {
                    completed.incrementAndGet();
                }
            });
        }
        return completed;
    }

    public static <V> AtomicInteger countCompletedCallables(int numTasks, Function<Callable<V>> submissionCallback) {
        final AtomicInteger completed = new AtomicInteger(0);
        for (int i = 0; i < numTasks; ++i) {
            submissionCallback.execute(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    completed.incrementAndGet();
                    return null;
                }
            });
        }
        return completed;
    }

    public static String generateString(int start, int length) {
        try {
            return new String(TestUtils.generateSequentialBytes(start, length), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateSequentialBytes(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)((start + i) % 127);
        }
        return result;
    }

    public static void waitUntilThreadBlocks(Thread t) {
        Thread.State state = t.getState();
        block4: while (true) {
            switch (state) {
                case NEW: 
                case RUNNABLE: {
                    state = t.getState();
                    continue block4;
                }
                case TERMINATED: 
                case BLOCKED: 
                case TIMED_WAITING: 
                case WAITING: {
                    return;
                }
            }
        }
    }

    public static Thread runInThread(Runnable runnable) {
        return TestUtils.runInThread(runnable, null);
    }

    public static Thread runInThread(Runnable runnable, String threadName) {
        Thread t = new Thread(runnable);
        if (threadName != null) {
            t.setName(threadName);
        }
        t.start();
        return t;
    }

    public static List<DateTime> generateMoments(DateTime baseDateTime, int count) {
        ArrayList<DateTime> result = new ArrayList<DateTime>(count);
        for (int i = 0; i < count; ++i) {
            result.add(baseDateTime.plusSeconds(i));
        }
        Collections.shuffle(result);
        return result;
    }

    public static Collection<DateTimeZone> getDistinctTimeZones() {
        LinkedHashMultimap timeZones = LinkedHashMultimap.create();
        for (Object obj : DateTimeZone.getAvailableIDs()) {
            String id = (String)obj;
            DateTimeZone dateTimeZone = DateTimeZone.forID((String)id);
            TimeZone timeZone = dateTimeZone.toTimeZone();
            timeZones.put((Object)timeZone.getRawOffset(), (Object)dateTimeZone);
            timeZones.put((Object)(timeZone.getRawOffset() + timeZone.getDSTSavings()), (Object)dateTimeZone);
        }
        HashSet<DateTimeZone> distinctZones = new HashSet<DateTimeZone>();
        for (Map.Entry entry : timeZones.asMap().entrySet()) {
            DateTimeZone fixedZone = null;
            DateTimeZone unfixedZone = null;
            for (DateTimeZone timeZone : (Collection)entry.getValue()) {
                if (timeZone.isFixed()) {
                    if (fixedZone != null) continue;
                    fixedZone = timeZone;
                    continue;
                }
                if (unfixedZone != null) continue;
                unfixedZone = timeZone;
            }
            if (fixedZone != null) {
                distinctZones.add(fixedZone);
            }
            if (unfixedZone == null) continue;
            distinctZones.add(unfixedZone);
        }
        return distinctZones;
    }

    public static void assertContains(String haystack, Object needle) {
        Assert.assertTrue((haystack != null && haystack.contains(String.valueOf(needle)) ? 1 : 0) != 0, (String)String.format("Expected to find '%s' in: %s", needle, haystack));
    }

    public static void assertEqualsWithNiceMessage(Object actual, Object expected) {
        TestUtils.assertEqualsWithNiceMessage(actual, expected, null);
    }

    public static void assertEqualsWithNiceMessage(Object actual, Object expected, String message) {
        message = message == null ? "" : message + " ";
        Assert.assertEquals((Object)actual, (Object)expected, (String)(message + "expected:<" + expected + "> but was:<" + actual + ">"));
    }
}

