/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.compress;

public class QuickLz {
    public final int QLZ_COMPRESSION_LEVEL = 1;
    public final int QLZ_STREAMING_BUFFER = 0;
    public final int QLZ_MEMORY_SAFE = 0;
    public final int QLZ_VERSION_MAJOR = 1;
    public final int QLZ_VERSION_MINOR = 4;
    public final int QLZ_VERSION_REVISION = 0;
    private static final int HASH_VALUES = 4096;
    private static final int MINOFFSET = 2;
    private static final int UNCONDITIONAL_MATCHLEN = 6;
    private static final int UNCOMPRESSED_END = 4;
    private static final int CWORD_LEN = 4;
    private static final int DEFAULT_HEADERLEN = 9;

    static int headerLen(byte[] source) {
        return (source[0] & 2) == 2 ? 9 : 3;
    }

    public static long sizeDecompressed(byte[] source) {
        if (QuickLz.headerLen(source) == 9) {
            return QuickLz.fastread(source, 5, 4);
        }
        return QuickLz.fastread(source, 2, 1);
    }

    public static long sizeCompressed(byte[] source) {
        if (QuickLz.headerLen(source) == 9) {
            return QuickLz.fastread(source, 1, 4);
        }
        return QuickLz.fastread(source, 1, 1);
    }

    public static byte[] compress(byte[] source) {
        int src = 0;
        int headerlen = 9;
        int dst = headerlen + 4;
        long cword_val = 0x80000000L;
        int cword_ptr = headerlen;
        byte[] destination = new byte[source.length + 400];
        int[] hashtable = new int[4096];
        int[] cachetable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int fetch = 0;
        int last_matchstart = source.length - 6 - 4 - 1;
        if (source.length == 0) {
            return new byte[0];
        }
        if (src <= last_matchstart) {
            fetch = (int)QuickLz.fastread(source, src, 3);
        }
        while (src <= last_matchstart) {
            if ((cword_val & 1L) == 1L) {
                if (src > 3 * (source.length >> 2) && dst > src - (src >> 5)) {
                    byte[] d2 = new byte[source.length + 9];
                    d2[0] = 2;
                    QuickLz.fastwrite(d2, 1, source.length + headerlen, 4);
                    QuickLz.fastwrite(d2, 5, source.length, 4);
                    System.arraycopy(source, 0, d2, headerlen, source.length);
                    return d2;
                }
                QuickLz.fastwrite(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            int hash = (fetch >>> 12 ^ fetch) & 0xFFF;
            int o = hashtable[hash];
            int cache = cachetable[hash] ^ fetch;
            cachetable[hash] = fetch;
            hashtable[hash] = src;
            if (cache == 0 && src - o > 2 && hash_counter[hash] != 0) {
                cword_val = cword_val >>> 1 | 0x80000000L;
                if (source[o + 3] != source[src + 3]) {
                    int f = 1 | hash << 4;
                    destination[dst + 0] = (byte)(f >>> 0);
                    destination[dst + 1] = (byte)(f >>> 8);
                    src += 3;
                    dst += 2;
                } else {
                    int f;
                    int remaining;
                    int old_src = src;
                    int n = remaining = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
                    if (source[o + (src += 4) - old_src] == source[src] && source[o + ++src - old_src] == source[src]) {
                        ++src;
                        while (source[o + (src - old_src)] == source[src] && src - old_src < remaining) {
                            ++src;
                        }
                    }
                    int matchlen = src - old_src;
                    hash <<= 4;
                    if (matchlen < 18) {
                        f = hash | matchlen - 2;
                        destination[dst + 0] = (byte)(f >>> 0);
                        destination[dst + 1] = (byte)(f >>> 8);
                        dst += 2;
                    } else {
                        f = hash | matchlen << 16;
                        QuickLz.fastwrite(destination, dst, f, 3);
                        dst += 3;
                    }
                }
                fetch = (int)QuickLz.fastread(source, src, 3);
                continue;
            }
            hash_counter[hash] = 1;
            destination[dst] = source[src];
            cword_val >>>= 1;
            ++dst;
            fetch = fetch >>> 8 & 0xFFFF | (source[++src + 2] & 0xFF) << 16;
        }
        while (src <= source.length - 1) {
            if ((cword_val & 1L) == 1L) {
                QuickLz.fastwrite(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            destination[dst] = source[src];
            ++src;
            ++dst;
            cword_val >>>= 1;
        }
        while ((cword_val & 1L) != 1L) {
            cword_val >>>= 1;
        }
        QuickLz.fastwrite(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
        destination[0] = 3;
        QuickLz.fastwrite(destination, 1, dst, 4);
        QuickLz.fastwrite(destination, 5, source.length, 4);
        byte[] d2 = new byte[dst];
        System.arraycopy(destination, 0, d2, 0, dst);
        return d2;
    }

    static long fastread(byte[] a, int i, int numbytes) {
        long l = 0L;
        switch (numbytes) {
            case 3: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                l |= ((long)a[i + 2] & 0xFFL) << 16;
                break;
            }
            case 2: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                break;
            }
            case 1: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                break;
            }
            case 4: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                l |= ((long)a[i + 2] & 0xFFL) << 16;
                l |= ((long)a[i + 3] & 0xFFL) << 24;
            }
        }
        return l;
    }

    static void fastwrite(byte[] a, int i, long value, int numbytes) {
        switch (numbytes) {
            case 3: {
                a[i] = (byte)value;
                a[i + 1] = (byte)(value >>> 8);
                a[i + 2] = (byte)(value >>> 16);
                break;
            }
            case 2: {
                a[i] = (byte)value;
                a[i + 1] = (byte)(value >>> 8);
                break;
            }
            case 4: {
                a[i] = (byte)value;
                a[i + 1] = (byte)(value >>> 8);
                a[i + 2] = (byte)(value >>> 16);
                a[i + 3] = (byte)(value >>> 24);
            }
        }
    }

    public static byte[] decompress(byte[] source) {
        int size = (int)QuickLz.sizeDecompressed(source);
        int src = QuickLz.headerLen(source);
        int dst = 0;
        long cword_val = 1L;
        byte[] destination = new byte[size];
        int[] hashtable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int last_matchstart = size - 6 - 4 - 1;
        int last_hashed = -1;
        int fetch = 0;
        if ((source[0] & 1) != 1) {
            byte[] d2 = new byte[size];
            System.arraycopy(source, QuickLz.headerLen(source), d2, 0, size);
            return d2;
        }
        while (true) {
            int hash;
            if (cword_val == 1L) {
                cword_val = QuickLz.fastread(source, src, 4);
                src += 4;
                if (dst <= last_matchstart) {
                    fetch = (int)QuickLz.fastread(source, src, 3);
                }
            }
            if ((cword_val & 1L) == 1L) {
                int matchlen;
                cword_val >>>= 1;
                hash = fetch >>> 4 & 0xFFF;
                int offset2 = hashtable[hash];
                if ((fetch & 0xF) != 0) {
                    matchlen = (fetch & 0xF) + 2;
                    src += 2;
                } else {
                    matchlen = source[src + 2] & 0xFF;
                    src += 3;
                }
                destination[dst + 0] = destination[offset2 + 0];
                destination[dst + 1] = destination[offset2 + 1];
                destination[dst + 2] = destination[offset2 + 2];
                for (int i = 3; i < matchlen; ++i) {
                    destination[dst + i] = destination[offset2 + i];
                }
                dst += matchlen;
                fetch = (int)QuickLz.fastread(destination, last_hashed + 1, 3);
                while (last_hashed < dst - matchlen) {
                    hash = (fetch >>> 12 ^ fetch) & 0xFFF;
                    hashtable[hash] = ++last_hashed;
                    hash_counter[hash] = 1;
                    fetch = fetch >>> 8 & 0xFFFF | (destination[last_hashed + 3] & 0xFF) << 16;
                }
                last_hashed = dst - 1;
                fetch = (int)QuickLz.fastread(source, src, 3);
                continue;
            }
            if (dst > last_matchstart) break;
            destination[dst] = source[src];
            ++dst;
            ++src;
            cword_val >>>= 1;
            while (last_hashed < dst - 3) {
                int fetch2 = (int)QuickLz.fastread(destination, ++last_hashed, 3);
                hash = (fetch2 >>> 12 ^ fetch2) & 0xFFF;
                hashtable[hash] = last_hashed;
                hash_counter[hash] = 1;
            }
            fetch = fetch >> 8 & 0xFFFF | (source[src + 2] & 0xFF) << 16;
        }
        while (dst <= size - 1) {
            if (cword_val == 1L) {
                src += 4;
                cword_val = 0x80000000L;
            }
            destination[dst] = source[src];
            ++dst;
            ++src;
            cword_val >>>= 1;
        }
        byte[] d2 = new byte[size];
        System.arraycopy(destination, 0, d2, 0, size);
        return d2;
    }
}

