/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.digest;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MurmurHash {
    public static final long JCOMMON_SEED = 1318007700L;
    private final long seed;
    private final HashFunction byteArrayHasher = Hashing.murmur3_128((int)1318007700);

    public MurmurHash(long seed) {
        this.seed = seed;
    }

    public static MurmurHash createRepeatableHasher() {
        return new MurmurHash(1318007700L);
    }

    private long rotateLeft64(long x, int r) {
        return x << r | x >>> 64 - r;
    }

    private long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public byte[] hash(byte[] data) {
        HashCode hashCode = this.byteArrayHasher.hashBytes(data);
        return hashCode.asBytes();
    }

    public long hashToLong(byte[] data) {
        HashCode hashCode = this.byteArrayHasher.hashBytes(data);
        return hashCode.asLong();
    }

    public long hash(long data) {
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long h1 = this.seed;
        long h2 = this.seed;
        long k1 = data;
        k1 *= c1;
        k1 = this.rotateLeft64(k1, 31);
        h1 ^= (k1 *= c2);
        h1 ^= 8L;
        return this.fmix(h1 += (h2 ^= 8L)) + this.fmix(h2 += h1);
    }
}

