/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.reflection;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;

public class ForwardReferenceProxy<T> {
    private final AtomicReference<T> instanceRef = new AtomicReference();
    private final Supplier<T> proxySupplier;

    public ForwardReferenceProxy(final Class<T> clazz) {
        this.proxySupplier = Suppliers.memoize((Supplier)new Supplier<T>(){

            public T get() {
                return ForwardReferenceProxy.wrap(clazz, ForwardReferenceProxy.this.instanceRef);
            }
        });
    }

    public ForwardReferenceProxy<T> setInstance(T instance) {
        this.instanceRef.set(instance);
        return this;
    }

    public T get() {
        return (T)this.proxySupplier.get();
    }

    private static <T> T wrap(Class<T> clazz, AtomicReference<T> instance) {
        Preconditions.checkNotNull(instance, (Object)"must pass a non-null atomic reference");
        InvocationHandler handler = (proxy, method, args) -> method.invoke(Preconditions.checkNotNull(instance.get(), (Object)"instance has not been set"), args);
        Object wrapper = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
        return (T)wrapper;
    }
}

