/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Convert {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static ByteBuffer toByteBuffer(String str) {
        if (str == null) {
            return null;
        }
        return UTF8.encode(str);
    }

    public static ByteBuffer toByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public static String toString(ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        return UTF8.decode(bb).toString();
    }

    public static byte[] toBytes(ByteBuffer bb) {
        if (bb.isReadOnly() || bb.isDirect()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(bb.limit());
                Channels.newChannel(out).write(bb);
                return out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (bb.array().length == bb.limit()) {
            return bb.array();
        }
        return Arrays.copyOfRange(bb.array(), bb.arrayOffset(), bb.arrayOffset() + bb.limit());
    }
}

