/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import com.facebook.util.ExtSupplier;
import com.facebook.util.RefreshableExtSupplier;

public class ExtSuppliers {
    public static <T, E extends Throwable> ExtSupplier<T, E> memoize(ExtSupplier<T, E> supplier) {
        return new MemoizingExtSupplier(supplier);
    }

    public static <T, E extends Throwable> RefreshableExtSupplier<T, E> memoizeAllowRefresh(ExtSupplier<T, E> supplier) {
        return new MemoizingExtSupplier(supplier);
    }

    public static <T, E extends Throwable> ExtSupplier<T, E> ofInstance(T instance) {
        return new InstanceExtSupplier(instance);
    }

    private static class InstanceExtSupplier<T, E extends Throwable>
    implements ExtSupplier<T, E> {
        private final T instance;

        private InstanceExtSupplier(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() throws E {
            return this.instance;
        }
    }

    private static class MemoizingExtSupplier<T, E extends Throwable>
    implements RefreshableExtSupplier<T, E> {
        private final ExtSupplier<T, E> delegate;
        private volatile boolean shouldCalculateValue = true;
        private T value;

        private MemoizingExtSupplier(ExtSupplier<T, E> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws E {
            if (this.shouldCalculateValue) {
                MemoizingExtSupplier memoizingExtSupplier = this;
                synchronized (memoizingExtSupplier) {
                    if (this.shouldCalculateValue) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.shouldCalculateValue = false;
                        return t;
                    }
                }
            }
            return this.value;
        }

        @Override
        public void reset() {
            this.shouldCalculateValue = true;
        }
    }
}

