/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import com.facebook.util.TimeIntervalType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;

public class TimeInterval {
    public static final TimeInterval INFINITE = new TimeInterval(null, 0L);
    public static final TimeInterval ZERO = new TimeInterval(null, -1L);
    private final long length;
    private final TimeIntervalType type;

    private TimeInterval(TimeIntervalType type, long length) {
        this.type = type;
        this.length = length;
    }

    public static TimeInterval withMillis(long millis) {
        TimeInterval.validateLength(millis);
        return new TimeInterval(null, millis);
    }

    public static TimeInterval withTypeAndLength(TimeIntervalType type, int length) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        TimeInterval.validateLength(length);
        return new TimeInterval(type, length);
    }

    @JsonCreator
    private static TimeInterval fromJson(@JsonProperty(value="type") TimeIntervalType type, @JsonProperty(value="length") long length) {
        if (type == null) {
            if (length == 0L) {
                return INFINITE;
            }
            if (length == -1L) {
                return ZERO;
            }
        }
        TimeInterval.validateLength(length);
        return new TimeInterval(type, length);
    }

    public DateTime getIntervalStart(DateTime instant) {
        if (this == ZERO) {
            return instant;
        }
        if (this == INFINITE) {
            return new DateTime(1970, 1, 1, 0, 0, 0, 0, instant.getZone());
        }
        if (this.type == null) {
            DateTime startOfTime = new DateTime(1970, 1, 1, 0, 0, 0, 0, instant.getZone());
            long intervalStart = (instant.getMillis() - startOfTime.getMillis()) / this.length * this.length;
            return startOfTime.plus(intervalStart);
        }
        return this.type.getTimeIntervalStart(instant, this.length);
    }

    public DateTime plus(DateTime instant, int multiple) {
        if (this == INFINITE) {
            throw new IllegalStateException("plus() function is not supported on an infinite TimeInterval");
        }
        if (this == ZERO) {
            return instant;
        }
        TimeInterval.validateMultiple(multiple);
        if (this.type == null) {
            return instant.plus((long)multiple * this.getLength());
        }
        return instant.plus((ReadablePeriod)this.type.toPeriod(FieldUtils.safeMultiplyToInt((long)multiple, (long)this.getLength())));
    }

    public DateTime minus(DateTime instant, int multiple) {
        if (this == INFINITE) {
            throw new IllegalStateException("minus() function is not supported on an infinite TimeInterval");
        }
        if (this == ZERO) {
            return instant;
        }
        TimeInterval.validateMultiple(multiple);
        if (this.type == null) {
            return instant.minus((long)multiple * this.getLength());
        }
        return instant.minus((ReadablePeriod)this.type.toPeriod(FieldUtils.safeMultiplyToInt((long)multiple, (long)this.getLength())));
    }

    public boolean isPeriod() {
        return this.type != null;
    }

    @JsonProperty(value="length")
    public long getLength() {
        return this.length;
    }

    @JsonProperty(value="type")
    public TimeIntervalType getType() {
        return this.type;
    }

    @Deprecated
    public long toApproxMillis() {
        if (this.type == null) {
            return this.length;
        }
        return this.type.toDurationMillis() * this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeInterval that = (TimeInterval)o;
        if (this.length != that.length) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TimeInterval{length=" + this.length + ", type=" + (Object)((Object)this.type) + '}';
    }

    private static void validateMultiple(int multiple) {
        if (multiple < 0) {
            throw new IllegalArgumentException("Multiple cannot be less that 0 : " + multiple);
        }
    }

    private static void validateLength(long length) {
        if (length < 1L) {
            throw new IllegalArgumentException("length cannot be less than one: " + length);
        }
    }
}

