/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import com.facebook.util.TimeUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;

public enum TimeIntervalType {
    MILLIS(PeriodType.millis(), DateTimeFieldType.millisOfSecond(), DateTimeFieldType.secondOfMinute()){

        @Override
        public Period toPeriod(int length) {
            return Period.millis((int)length);
        }
    }
    ,
    SECOND(PeriodType.seconds(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.minuteOfHour()){

        @Override
        public Period toPeriod(int length) {
            return Period.seconds((int)length);
        }
    }
    ,
    MINUTE(PeriodType.minutes(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.hourOfDay()){

        @Override
        public Period toPeriod(int length) {
            return Period.minutes((int)length);
        }
    }
    ,
    HOUR(PeriodType.hours(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.dayOfMonth()){

        @Override
        public Period toPeriod(int length) {
            return Period.hours((int)length);
        }
    }
    ,
    DAY(PeriodType.days(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.monthOfYear()){

        @Override
        public Period toPeriod(int length) {
            return Period.days((int)length);
        }
    }
    ,
    WEEK(PeriodType.weeks(), DateTimeFieldType.weekOfWeekyear(), DateTimeFieldType.yearOfCentury()){

        @Override
        public Period toPeriod(int length) {
            return Period.weeks((int)length);
        }
    }
    ,
    MONTH(PeriodType.months(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.yearOfCentury()){

        @Override
        public Period toPeriod(int length) {
            return Period.months((int)length);
        }
    }
    ,
    YEAR(PeriodType.years(), DateTimeFieldType.yearOfCentury(), DateTimeFieldType.centuryOfEra()){

        @Override
        public Period toPeriod(int length) {
            return Period.years((int)length);
        }
    };

    private final PeriodType periodType;
    private final DateTimeFieldType fieldType;
    private final DateTimeFieldType truncateFieldType;

    private TimeIntervalType(PeriodType periodType, DateTimeFieldType fieldType, DateTimeFieldType truncateFieldType) {
        this.periodType = periodType;
        this.fieldType = fieldType;
        this.truncateFieldType = truncateFieldType;
    }

    public abstract Period toPeriod(int var1);

    public void validateValue(DateTimeZone timeZone, long intervalLength) {
        DateTimeField field = this.fieldType.getField((Chronology)TimeUtil.getChronology(timeZone.getID()));
        if (intervalLength < 1L || intervalLength > (long)field.getMaximumValue()) {
            throw new IllegalArgumentException("Supplied value " + intervalLength + " is out of bounds for " + this.name());
        }
    }

    public DateTime getTimeIntervalStart(DateTime instant, long length) {
        this.validateValue(instant.getZone(), length);
        DateTime periodStart = instant.property(this.truncateFieldType).roundFloorCopy();
        Period period = new Period((ReadableInstant)periodStart, (ReadableInstant)instant, this.periodType);
        DurationField durationField = this.fieldType.getField(instant.getChronology()).getDurationField();
        int diff = period.get(durationField.getType());
        long startDelta = (long)diff / length * length;
        return periodStart.withFieldAdded(durationField.getType(), FieldUtils.safeToInt((long)startDelta));
    }

    public long toDurationMillis() {
        return this.fieldType.getDurationType().getField((Chronology)ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC)).getUnitMillis();
    }
}

