/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.facebook.util.ExtCallable;
import com.facebook.util.ExtRunnable;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.chrono.ISOChronology;

public class TimeUtil {
    private static final Logger LOG = LoggerImpl.getLogger(TimeUtil.class);
    private static final Map<String, DateTimeZone> TIME_ZONE_MAP;
    private static final Map<String, ISOChronology> CHRONOLOGY_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void logElapsedTime(String tag, ExtRunnable<E> task) throws E {
        long start = DateTimeUtils.currentTimeMillis();
        boolean success = false;
        try {
            task.run();
            success = true;
        }
        catch (Throwable throwable) {
            LOG.info("%s (%s) elapsed time(ms): %d", new Object[]{tag, success, DateTimeUtils.currentTimeMillis() - start});
            throw throwable;
        }
        LOG.info("%s (%s) elapsed time(ms): %d", new Object[]{tag, success, DateTimeUtils.currentTimeMillis() - start});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, E extends Throwable> V logElapsedTime(String tag, ExtCallable<V, E> task) throws E {
        V v;
        long start = DateTimeUtils.currentTimeMillis();
        boolean success = false;
        try {
            V value = task.call();
            success = true;
            v = value;
        }
        catch (Throwable throwable) {
            LOG.info("%s (%s) elapsed time(ms): %d", new Object[]{tag, success, DateTimeUtils.currentTimeMillis() - start});
            throw throwable;
        }
        LOG.info("%s (%s) elapsed time(ms): %d", new Object[]{tag, success, DateTimeUtils.currentTimeMillis() - start});
        return v;
    }

    public static DateTimeZone getDateTimeZone(String dateTimeZoneStr) {
        if (dateTimeZoneStr == null || dateTimeZoneStr.isEmpty()) {
            return DateTimeZone.UTC;
        }
        return TIME_ZONE_MAP.get(dateTimeZoneStr);
    }

    public static ISOChronology getChronology(String dateTimeZoneStr) {
        if (dateTimeZoneStr == null || dateTimeZoneStr.isEmpty()) {
            dateTimeZoneStr = DateTimeZone.UTC.getID();
        }
        return CHRONOLOGY_MAP.get(dateTimeZoneStr);
    }

    public static void setNow(DateTime now) {
        DateTimeUtils.setCurrentMillisFixed((long)now.getMillis());
    }

    public static void advanceNow(Duration duration) {
        long now = DateTimeUtils.currentTimeMillis();
        DateTimeUtils.setCurrentMillisFixed((long)(now + duration.getMillis()));
    }

    static {
        ImmutableMap.Builder timeZoneBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder chronologyBuilder = new ImmutableMap.Builder();
        for (Object id : DateTimeZone.getAvailableIDs()) {
            String tz = (String)id;
            DateTimeZone timeZone = DateTimeZone.forID((String)tz);
            timeZoneBuilder.put((Object)tz, (Object)timeZone);
            chronologyBuilder.put((Object)tz, (Object)ISOChronology.getInstance((DateTimeZone)timeZone));
        }
        TIME_ZONE_MAP = timeZoneBuilder.build();
        CHRONOLOGY_MAP = chronologyBuilder.build();
    }
}

