/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util;

import com.facebook.util.ExceptionUtils;
import com.google.common.base.Preconditions;

public class Validator<T extends Exception> {
    private final Class<T> clazz;

    public Validator(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void checkState(boolean expression) throws T {
        try {
            Preconditions.checkState((boolean)expression);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap(e, this.clazz);
        }
    }

    public void checkState(boolean expression, String message) throws T {
        try {
            Preconditions.checkState((boolean)expression, (Object)message);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap(e, this.clazz);
        }
    }

    public void checkState(boolean expression, String message, Object ... errorMessageArgs) throws T {
        try {
            Preconditions.checkState((boolean)expression, (String)message, (Object[])errorMessageArgs);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap(e, this.clazz);
        }
    }
}

