/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.function.ExtBooleanSupplier;
import java.util.Objects;
import java.util.function.BiPredicate;

public interface ExtBiPredicate<T, U, E extends Throwable> {
    public boolean test(T var1, U var2) throws E;

    default public ExtBiPredicate<T, U, E> and(ExtBiPredicate<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) && other.test(t, u);
    }

    default public ExtBiPredicate<T, U, E> negate() {
        return (t, u) -> !this.test(t, u);
    }

    default public ExtBiPredicate<T, U, E> or(ExtBiPredicate<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) || other.test(t, u);
    }

    public static <T, U> BiPredicate<T, U> quiet(ExtBiPredicate<T, U, ?> biPredicate) {
        return (t, u) -> ExtBooleanSupplier.quiet(() -> biPredicate.test(t, u)).getAsBoolean();
    }
}

