/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.exceptions.UncheckedCheckedException;
import java.util.function.BooleanSupplier;

public interface ExtBooleanSupplier<E extends Throwable> {
    public boolean getAsBoolean() throws E;

    public static BooleanSupplier quiet(ExtBooleanSupplier<?> booleanSupplier) {
        return () -> {
            try {
                return booleanSupplier.getAsBoolean();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UncheckedCheckedException(e);
            }
        };
    }
}

