/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.exceptions.UncheckedCheckedException;
import java.util.function.DoubleSupplier;

public interface ExtDoubleSupplier<E extends Throwable> {
    public double getAsDouble() throws E;

    public static DoubleSupplier quiet(ExtDoubleSupplier<?> doubleSupplier) {
        return () -> {
            try {
                return doubleSupplier.getAsDouble();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UncheckedCheckedException(e);
            }
        };
    }
}

