/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.function.ExtBooleanSupplier;
import java.util.Objects;
import java.util.function.IntPredicate;

public interface ExtIntPredicate<E extends Throwable> {
    public boolean test(int var1) throws E;

    default public ExtIntPredicate<E> and(ExtIntPredicate<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public ExtIntPredicate<E> negate() {
        return value -> !this.test(value);
    }

    default public ExtIntPredicate<E> or(ExtIntPredicate<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    public static IntPredicate quiet(ExtIntPredicate<?> intPredicate) {
        return value -> ExtBooleanSupplier.quiet(() -> intPredicate.test(value)).getAsBoolean();
    }
}

