/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.exceptions.UncheckedCheckedException;
import java.util.function.IntSupplier;

public interface ExtIntSupplier<E extends Throwable> {
    public int getAsInt() throws E;

    public static IntSupplier quiet(ExtIntSupplier<?> intSupplier) {
        return () -> {
            try {
                return intSupplier.getAsInt();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UncheckedCheckedException(e);
            }
        };
    }
}

