/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.exceptions.UncheckedCheckedException;
import java.util.function.LongSupplier;

public interface ExtLongSupplier<E extends Throwable> {
    public long getAsLong() throws E;

    public static LongSupplier quiet(ExtLongSupplier<?> longSupplier) {
        return () -> {
            try {
                return longSupplier.getAsLong();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UncheckedCheckedException(e);
            }
        };
    }
}

