/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.util.function;

import com.facebook.util.function.ExtBooleanSupplier;
import java.util.Objects;
import java.util.function.Predicate;

public interface ExtPredicate<T, E extends Throwable> {
    public boolean test(T var1) throws E;

    default public ExtPredicate<T, E> and(ExtPredicate<? super T, E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public ExtPredicate<T, E> negate() {
        return t -> !this.test(t);
    }

    default public ExtPredicate<T, E> or(ExtPredicate<? super T, E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> Predicate<T> quiet(ExtPredicate<T, ?> predicate) {
        return t -> ExtBooleanSupplier.quiet(() -> predicate.test(t)).getAsBoolean();
    }
}

