/*
 * Copyright (C) 2012 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.zookeeper.mock;

import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

import java.util.LinkedList;
import java.util.Queue;

public class MockWatcher implements Watcher {
  private Queue<WatchedEvent> eventQueue = new LinkedList<WatchedEvent>();

  public Queue<WatchedEvent> getEventQueue() {
    return eventQueue;
  }

  @Override
  public void process(WatchedEvent event) {
    eventQueue.offer(event);
  }
}
