/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper;

import com.facebook.zookeeper.BasicZooKeeperFactory;
import com.facebook.zookeeper.RecoveringZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperIface;
import java.io.IOException;
import org.apache.zookeeper.Watcher;

public class DefaultZooKeeperFactory
implements ZooKeeperFactory {
    private final String zkHostStr;
    private final int timeoutMillis;
    private final int maxRetries;
    private final int retryIntervalMillis;

    public DefaultZooKeeperFactory(String zkHostStr, int timeoutMillis, int maxRetries, int retryIntervalMillis) {
        this.zkHostStr = zkHostStr;
        this.timeoutMillis = timeoutMillis;
        this.maxRetries = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public DefaultZooKeeperFactory(String zkHostStr, int timeoutMillis) {
        this(zkHostStr, timeoutMillis, 3, 1000);
    }

    @Override
    public ZooKeeperIface create(Watcher watcher) throws IOException {
        BasicZooKeeperFactory sinkZooKeeperFactory = new BasicZooKeeperFactory(this.zkHostStr, this.timeoutMillis);
        RecoveringZooKeeperFactory recoveringZooKeeperFactory = new RecoveringZooKeeperFactory(sinkZooKeeperFactory, this.maxRetries, this.retryIntervalMillis);
        return recoveringZooKeeperFactory.create(watcher);
    }
}

