/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper;

import com.facebook.zookeeper.ZkUtil;
import com.facebook.zookeeper.ZooKeeperIface;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveringZooKeeper
implements ZooKeeperIface {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveringZooKeeper.class);
    private final ZooKeeperIface zk;
    private final RetryCounterFactory retryCounterFactory;

    public RecoveringZooKeeper(ZooKeeperIface zk, int maxRetries, int retryIntervalMillis) {
        this.zk = zk;
        this.retryCounterFactory = new RetryCounterFactory(maxRetries, retryIntervalMillis);
    }

    @Override
    public long getSessionId() {
        return this.zk.getSessionId();
    }

    @Override
    public void close() throws InterruptedException {
        this.zk.close();
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        switch (createMode) {
            case EPHEMERAL: 
            case PERSISTENT: {
                return this.createNonSequential(path, data, acl, createMode);
            }
            case EPHEMERAL_SEQUENTIAL: {
                return this.createEphemeralSequential(path, data, acl, createMode);
            }
            case PERSISTENT_SEQUENTIAL: {
                return this.zk.create(path, data, acl, createMode);
            }
        }
        throw new IllegalArgumentException("Unrecognized CreateMode: " + createMode);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                this.zk.delete(path, version);
                return;
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case NONODE: {
                        return;
                    }
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper delete failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.exists(path, watcher);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper exists failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.exists(path, watch);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper exists failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.getData(path, watcher, stat);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper getData failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.getData(path, watch, stat);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper getData failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.setData(path, data, version);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper setData failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.getChildren(path, watcher);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper getChildren failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.getChildren(path, watch);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper getChildren failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public ZooKeeper.States getState() {
        return this.zk.getState();
    }

    private String createNonSequential(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.zk.create(path, data, acl, createMode);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case NODEEXISTS: {
                        return path;
                    }
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper create failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    private String createEphemeralSequential(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        boolean first = true;
        while (true) {
            try {
                String myNode;
                if (!first && (myNode = this.findMyEphemeralSequentialNode(path)) != null) {
                    return myNode;
                }
                first = false;
                return this.zk.create(path, data, acl, createMode);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        if (retryCounter.shouldRetry()) break;
                        LOG.error("ZooKeeper create failed after " + retryCounter.getMaxRetries() + " retries");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
                LOG.info("Retrying ZooKeeper after sleeping...");
                retryCounter.sleepUntilNextRetry();
                retryCounter.useRetry();
                continue;
            }
            break;
        }
    }

    private String findMyEphemeralSequentialNode(String path) throws KeeperException, InterruptedException {
        int lastSlashIdx = path.lastIndexOf(47);
        assert (lastSlashIdx != -1);
        String parent = path.substring(0, lastSlashIdx);
        String nodePrefix = path.substring(lastSlashIdx + 1);
        List<String> nodes = this.zk.getChildren(parent, false);
        List<String> matching = ZkUtil.filterByPrefix(nodes, nodePrefix);
        for (String node : matching) {
            String nodePath = parent + "/" + node;
            Stat stat = this.zk.exists(nodePath, false);
            if (stat == null || stat.getEphemeralOwner() != this.zk.getSessionId()) continue;
            return nodePath;
        }
        return null;
    }

    private static class RetryCounter {
        private final int maxRetries;
        private int retriesRemaining;
        private final int retryIntervalMillis;
        private final TimeUnit timeUnit;

        private RetryCounter(int maxRetries, int retryIntervalMillis, TimeUnit timeUnit) {
            this.maxRetries = maxRetries;
            this.retriesRemaining = maxRetries;
            this.retryIntervalMillis = retryIntervalMillis;
            this.timeUnit = timeUnit;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public void sleepUntilNextRetry() throws InterruptedException {
            this.timeUnit.sleep(this.retryIntervalMillis);
        }

        public boolean shouldRetry() {
            return this.retriesRemaining > 0;
        }

        public void useRetry() {
            --this.retriesRemaining;
        }
    }

    private static class RetryCounterFactory {
        private final int maxRetries;
        private final int retryIntervalMillis;

        private RetryCounterFactory(int maxRetries, int retryIntervalMillis) {
            this.maxRetries = maxRetries;
            this.retryIntervalMillis = retryIntervalMillis;
        }

        public RetryCounter create() {
            return new RetryCounter(this.maxRetries, this.retryIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }
}

