/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.app;

import com.facebook.concurrency.ErrorLoggingRunnable;
import com.facebook.concurrency.NamedThreadFactory;
import com.facebook.zookeeper.connection.ZkConnectionManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkApplication {
    private static final Logger APP_LOG = LoggerFactory.getLogger(ZkApplication.class);
    protected final ZkConnectionManager zkConnectionManager;
    private final ExecutorService watchExecutor;
    private final ScheduledExecutorService retryExecutor;
    private final long retryIntervalMillis;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final StateContext context = new StateContext();
    private volatile boolean isStarted = false;

    protected ZkApplication(ZkConnectionManager zkConnectionManager, long retryIntervalMillis, ExecutorService watchExecutor, ScheduledExecutorService retryExecutor) {
        this.zkConnectionManager = zkConnectionManager;
        this.retryIntervalMillis = retryIntervalMillis;
        this.watchExecutor = watchExecutor;
        this.retryExecutor = retryExecutor;
    }

    protected ZkApplication(ZkConnectionManager zkConnectionManager, long retryIntervalMillis) {
        this(zkConnectionManager, retryIntervalMillis, Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("ZkApplication-watch")), Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ZkApplication-retry")));
    }

    protected ZkApplication(ZkConnectionManager zkConnectionManager) {
        this(zkConnectionManager, 2000L);
    }

    public synchronized void start() {
        if (this.isStarted) {
            throw new IllegalStateException("Should only be started once");
        }
        ZooKeeper.States zkState = this.zkConnectionManager.registerWatcher(new ConnectionWatcher());
        this.context.start(zkState == ZooKeeper.States.CONNECTED ? State.CONNECTED : State.DISCONNECTED);
        this.isStarted = true;
        this.initLatch.countDown();
    }

    public boolean isFunctional() {
        return this.context.getState() == State.FUNCTIONAL;
    }

    public boolean isSafeMode() {
        return this.context.getState() == State.SAFEMODE || this.context.getState() == State.SAFEMODE_REPAIR;
    }

    public boolean isShutdown() {
        return this.context.getState() == State.SHUTDOWN;
    }

    public synchronized void shutdown() {
        if (!this.isStarted) {
            throw new IllegalStateException("Application not yet started");
        }
        this.context.shutdown();
        this.watchExecutor.shutdown();
        this.retryExecutor.shutdown();
    }

    protected abstract boolean initialize();

    protected abstract boolean repair();

    protected abstract void expire();

    private class StateContext {
        private volatile State state = State.PRESTART;
        private final Object transitionLock = new Object();
        private final Map<State, StateHandler> handlerCache = new EnumMap<State, StateHandler>(State.class);

        private StateContext() {
            this.handlerCache.put(State.PRESTART, new PreStartStateHandler());
            this.handlerCache.put(State.DISCONNECTED, new DisconnectedStateHandler());
            this.handlerCache.put(State.CONNECTED, new ConnectedStateHandler());
            this.handlerCache.put(State.FUNCTIONAL, new FunctionalStateHandler());
            this.handlerCache.put(State.SAFEMODE, new SafeModeStateHandler());
            this.handlerCache.put(State.SAFEMODE_REPAIR, new SafeModeRepairStateHandler());
            this.handlerCache.put(State.SHUTDOWN, new ShutdownStateHandler());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(State initialState) {
            Object object = this.transitionLock;
            synchronized (object) {
                this.transition(initialState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Watcher.Event.KeeperState event) {
            Object object = this.transitionLock;
            synchronized (object) {
                this.getHandler().handleEvent(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.transitionLock;
            synchronized (object) {
                if (this.state == State.SHUTDOWN) {
                    APP_LOG.warn("Multiple shutdown calls");
                    return;
                }
                this.internalTransition(State.SHUTDOWN);
            }
        }

        public State getState() {
            return this.state;
        }

        private StateHandler getHandler() {
            return this.handlerCache.get((Object)this.state);
        }

        private void transition(State newState) {
            if (newState == State.SHUTDOWN) {
                throw new IllegalArgumentException("Set SHUTDOWN state by calling the shutdown method");
            }
            if (this.state != State.SHUTDOWN) {
                this.internalTransition(newState);
            }
        }

        private void internalTransition(State newState) {
            this.getHandler().outboundHook();
            this.state = newState;
            this.getHandler().inboundHook();
        }

        private class ShutdownStateHandler
        implements StateHandler {
            private ShutdownStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
            }

            @Override
            public void inboundHook() {
                ZkApplication.this.expire();
            }

            @Override
            public void outboundHook() {
            }
        }

        private class SafeModeRepairStateHandler
        implements StateHandler {
            private volatile boolean isActive = false;
            private volatile boolean isScheduled = false;
            private final Object scheduleCheckLock = new Object();

            private SafeModeRepairStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
                switch (event) {
                    case SyncConnected: {
                        break;
                    }
                    case Disconnected: {
                        ZkApplication.this.context.transition(State.SAFEMODE);
                        break;
                    }
                    case Expired: {
                        ZkApplication.this.context.transition(State.DISCONNECTED);
                        ZkApplication.this.expire();
                    }
                }
            }

            @Override
            public void inboundHook() {
                this.startRepairLoop();
            }

            private void startRepairLoop() {
                this.isActive = true;
                if (this.scheduleCompareAndSet()) {
                    ZkApplication.this.retryExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Object object = StateContext.this.transitionLock;
                                synchronized (object) {
                                    block9: {
                                        if (ZkApplication.this.context.getState() != State.SAFEMODE_REPAIR || !ZkApplication.this.repair()) break block9;
                                        ZkApplication.this.context.transition(State.FUNCTIONAL);
                                        return;
                                    }
                                }
                            }
                            finally {
                                SafeModeRepairStateHandler.this.isScheduled = false;
                            }
                            if (SafeModeRepairStateHandler.this.scheduleCompareAndSet()) {
                                ZkApplication.this.retryExecutor.schedule(this, ZkApplication.this.retryIntervalMillis, TimeUnit.MILLISECONDS);
                            }
                        }
                    }));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean scheduleCompareAndSet() {
                Object object = this.scheduleCheckLock;
                synchronized (object) {
                    if (this.isActive && !this.isScheduled) {
                        this.isScheduled = true;
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public void outboundHook() {
                this.stopRepairLoop();
            }

            private void stopRepairLoop() {
                this.isActive = false;
            }
        }

        private class SafeModeStateHandler
        implements StateHandler {
            private SafeModeStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
                switch (event) {
                    case SyncConnected: {
                        ZkApplication.this.context.transition(State.SAFEMODE_REPAIR);
                        break;
                    }
                    case Disconnected: {
                        break;
                    }
                    case Expired: {
                        ZkApplication.this.context.transition(State.DISCONNECTED);
                        ZkApplication.this.expire();
                    }
                }
            }

            @Override
            public void inboundHook() {
            }

            @Override
            public void outboundHook() {
            }
        }

        private class FunctionalStateHandler
        implements StateHandler {
            private FunctionalStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
                switch (event) {
                    case SyncConnected: {
                        break;
                    }
                    case Disconnected: {
                        ZkApplication.this.context.transition(State.SAFEMODE);
                        break;
                    }
                    case Expired: {
                        ZkApplication.this.context.transition(State.DISCONNECTED);
                        ZkApplication.this.expire();
                    }
                }
            }

            @Override
            public void inboundHook() {
            }

            @Override
            public void outboundHook() {
            }
        }

        private class ConnectedStateHandler
        implements StateHandler {
            private volatile boolean isActive = false;
            private volatile boolean isScheduled = false;
            private final Object scheduleCheckLock = new Object();

            private ConnectedStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
                switch (event) {
                    case SyncConnected: {
                        break;
                    }
                    case Disconnected: {
                        ZkApplication.this.context.transition(State.DISCONNECTED);
                        break;
                    }
                    case Expired: {
                        ZkApplication.this.context.transition(State.DISCONNECTED);
                        ZkApplication.this.expire();
                    }
                }
            }

            @Override
            public void inboundHook() {
                this.startInitLoop();
            }

            private void startInitLoop() {
                this.isActive = true;
                if (this.scheduleCompareAndSet()) {
                    ZkApplication.this.retryExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Object object = StateContext.this.transitionLock;
                                synchronized (object) {
                                    block9: {
                                        if (ZkApplication.this.context.getState() != State.CONNECTED || !ZkApplication.this.initialize()) break block9;
                                        ZkApplication.this.context.transition(State.FUNCTIONAL);
                                        return;
                                    }
                                }
                            }
                            finally {
                                ConnectedStateHandler.this.isScheduled = false;
                            }
                            if (ConnectedStateHandler.this.scheduleCompareAndSet()) {
                                ZkApplication.this.retryExecutor.schedule(this, ZkApplication.this.retryIntervalMillis, TimeUnit.MILLISECONDS);
                            }
                        }
                    }));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean scheduleCompareAndSet() {
                Object object = this.scheduleCheckLock;
                synchronized (object) {
                    if (this.isActive && !this.isScheduled) {
                        this.isScheduled = true;
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public void outboundHook() {
                this.stopRepairLoop();
            }

            private void stopRepairLoop() {
                this.isActive = false;
            }
        }

        private class DisconnectedStateHandler
        implements StateHandler {
            private DisconnectedStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
                switch (event) {
                    case SyncConnected: {
                        ZkApplication.this.context.transition(State.CONNECTED);
                        break;
                    }
                    case Disconnected: {
                        break;
                    }
                }
            }

            @Override
            public void inboundHook() {
            }

            @Override
            public void outboundHook() {
            }
        }

        private class PreStartStateHandler
        implements StateHandler {
            private PreStartStateHandler() {
            }

            @Override
            public void handleEvent(Watcher.Event.KeeperState event) {
            }

            @Override
            public void inboundHook() {
            }

            @Override
            public void outboundHook() {
            }
        }
    }

    private static interface StateHandler {
        public void handleEvent(Watcher.Event.KeeperState var1);

        public void inboundHook();

        public void outboundHook();
    }

    private class ConnectionWatcher
    implements Watcher {
        private ConnectionWatcher() {
        }

        public void process(final WatchedEvent event) {
            ZkApplication.this.watchExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZkApplication.this.initLatch.await();
                    }
                    catch (InterruptedException e) {
                        APP_LOG.error("Init latch interrupted, continuing...");
                        Thread.currentThread().interrupt();
                    }
                    ZkApplication.this.context.handleEvent(event.getState());
                }
            }));
        }
    }

    public static enum State {
        PRESTART,
        DISCONNECTED,
        CONNECTED,
        FUNCTIONAL,
        SAFEMODE,
        SAFEMODE_REPAIR,
        SHUTDOWN;

    }
}

