/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.cmd;

import com.facebook.util.StreamImporter;
import com.facebook.zookeeper.cmd.ZNodeBulkLoader;
import com.facebook.zookeeper.cmd.ZNodePruner;
import com.facebook.zookeeper.convenience.ZkQuickConnectionManager;
import com.facebook.zookeeper.convenience.ZkScript;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ZNodeSync
extends ZkScript {
    private final ZNodeBulkLoader loader;
    private final ZNodePruner pruner;

    public ZNodeSync(ZkQuickConnectionManager zkQuickConnectionManager) {
        super(zkQuickConnectionManager);
        this.loader = new ZNodeBulkLoader(zkQuickConnectionManager);
        this.pruner = new ZNodePruner(zkQuickConnectionManager);
    }

    public ZNodeSync() {
        this(new ZkQuickConnectionManager());
    }

    public void setVerbose(boolean verbose) {
        this.loader.setVerbose(verbose);
        this.pruner.setVerbose(verbose);
    }

    @Override
    protected String getName() {
        return ZNodeSync.class.getName();
    }

    @Override
    protected Options getSpecificOptions() {
        Options options = new Options();
        options.addOption("z", "zkpath", true, "ZooKeeper path to sync (includes all descendants) [Required]");
        options.addOption("k", "keyword", true, "Keyword to write into zNodes that will be removed. This may be used to help reduce activity on or underneath this node [Default: freeze]");
        options.addOption("f", "file-template", true, "Path to file containing new-line delimited list of ZNodes to sync. The list only applies to persistent ZNodes. If this parameter is not specified, expects the values to be provided via standard input.");
        options.addOption("v", "verbose", false, "Print verbose messages [Default: off]");
        return options;
    }

    @Override
    protected boolean verifySpecificOptions(CommandLine cmd) {
        File template;
        if (!cmd.hasOption("zkpath")) {
            System.err.println("Error: You must specify a ZooKeeper path.\n");
            return false;
        }
        if (cmd.hasOption("file-template") && !(template = new File(cmd.getOptionValue("file-template"))).exists()) {
            System.err.println("Error: invalid file-template path.\n");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runScript(CommandLine cmd) throws Exception {
        this.setVerbose(cmd.hasOption("verbose"));
        String root = cmd.getOptionValue("zkpath");
        String keyword = cmd.getOptionValue("keyword", "freeze");
        try (InputStream in = cmd.hasOption("file-template") ? new FileInputStream(new File(cmd.getOptionValue("file-template"))) : System.in;){
            List template = StreamImporter.importLines((InputStream)in);
            this.loader.load(template);
            this.pruner.prunePersistent(root, keyword, template);
        }
    }

    public static void main(String[] args) throws Exception {
        ZNodeSync script = new ZNodeSync();
        script.runMain(args);
        System.out.println("DONE");
    }
}

