/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.connection;

import com.facebook.concurrency.ErrorLoggingRunnable;
import com.facebook.concurrency.NamedThreadFactory;
import com.facebook.zookeeper.ZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.connection.ZkConnectionManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConnectionManagerImpl
implements ZkConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConnectionManagerImpl.class);
    private final ZooKeeperFactory zooKeeperFactory;
    private final List<Watcher> registeredWatchers = new CopyOnWriteArrayList<Watcher>();
    private final ConnectionWatcher connectionWatcher = new ConnectionWatcher();
    private final ConnectionRenewer connectionRenewer = new ConnectionRenewer();
    private final int connectTimeoutMillis;
    private final int retryIntervalMillis;
    private volatile ZooKeeperIface zk = null;
    private volatile boolean isStarted = false;
    private volatile boolean isShutDown = false;

    public ZkConnectionManagerImpl(ZooKeeperFactory zooKeeperFactory, int connectTimeoutMillis, int retryIntervalMillis) {
        this.zooKeeperFactory = zooKeeperFactory;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public synchronized void start() {
        if (this.isStarted) {
            throw new IllegalStateException("Should only be started once");
        }
        try {
            this.connect();
        }
        catch (IOException e) {
            this.connectionRenewer.activate();
        }
        this.isStarted = true;
    }

    private void verifyOperational() {
        if (!this.isStarted) {
            throw new IllegalStateException("Not yet started");
        }
        if (this.isShutDown) {
            throw new IllegalStateException("Already closed");
        }
    }

    private boolean isAlive() {
        return this.zk != null && this.zk.getState().isAlive();
    }

    private synchronized void connect() throws IOException {
        if (!this.isShutDown && !this.isAlive()) {
            LOG.info("Initializing ZooKeeper connection");
            this.connectionWatcher.reset();
            this.zk = this.zooKeeperFactory.create(this.connectionWatcher);
        }
    }

    @Override
    public ZooKeeperIface getClient() throws InterruptedException {
        this.verifyOperational();
        if (!this.connectionWatcher.waitForConnect(this.connectTimeoutMillis, TimeUnit.MILLISECONDS)) {
            LOG.error("Exceeded " + this.connectTimeoutMillis + " ms waiting for connection to be established! Using disconnected client...");
        }
        return this.zk;
    }

    @Override
    public ZooKeeper.States registerWatcher(Watcher watcher) {
        this.registeredWatchers.add(watcher);
        return this.zk == null ? ZooKeeper.States.CLOSED : this.zk.getState();
    }

    @Override
    public synchronized void shutdown() throws InterruptedException {
        LOG.info("Closing ZooKeeper connection");
        this.verifyOperational();
        try {
            this.connectionRenewer.shutdown();
            if (this.isAlive()) {
                this.zk.close();
            }
        }
        finally {
            this.isShutDown = true;
        }
    }

    private class ConnectionWatcher
    implements Watcher {
        private volatile CountDownLatch connectedSignal = new CountDownLatch(1);

        private ConnectionWatcher() {
        }

        public synchronized void reset() {
            this.connectedSignal.countDown();
            this.connectedSignal = new CountDownLatch(1);
        }

        public boolean waitForConnect(int timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.connectedSignal.await(timeout, timeUnit);
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info("ZooKeeper connected");
                    this.connectedSignal.countDown();
                    break;
                }
                case Disconnected: {
                    LOG.warn("ZooKeeper disconnected!");
                    break;
                }
                case Expired: {
                    LOG.warn("ZooKeeper session expired!");
                    ZkConnectionManagerImpl.this.connectionRenewer.activate();
                }
            }
            for (Watcher watcher : ZkConnectionManagerImpl.this.registeredWatchers) {
                try {
                    watcher.process(event);
                }
                catch (Throwable t) {
                    LOG.error("Registered watcher failed handling connection event", t);
                }
            }
        }
    }

    private class ConnectionRenewer {
        private final ScheduledExecutorService retryExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ZkConnectionManager-renewer"));
        private final AtomicBoolean isScheduled = new AtomicBoolean(false);

        private ConnectionRenewer() {
        }

        public void activate() {
            if (this.isScheduled.compareAndSet(false, true)) {
                this.retryExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ZkConnectionManagerImpl.this.connect();
                            return;
                        }
                        catch (IOException e) {
                            LOG.error("Failed to connect to ZooKeeper", (Throwable)e);
                        }
                        finally {
                            ConnectionRenewer.this.isScheduled.set(false);
                        }
                        if (ConnectionRenewer.this.isScheduled.compareAndSet(false, true)) {
                            ConnectionRenewer.this.retryExecutor.schedule(this, (long)ZkConnectionManagerImpl.this.retryIntervalMillis, TimeUnit.MILLISECONDS);
                        }
                    }
                }));
            }
        }

        public void shutdown() {
            this.retryExecutor.shutdown();
        }
    }
}

