/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.convenience;

import com.facebook.zookeeper.BasicZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperIface;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZkQuickConnection {
    private final ZooKeeperIface zk;

    private ZkQuickConnection(ZooKeeperFactory zooKeeperFactory, int connectionTimeoutMillis) throws IOException, InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.zk = zooKeeperFactory.create(new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        });
        if (!latch.await(connectionTimeoutMillis, TimeUnit.MILLISECONDS)) {
            this.zk.close();
            throw new TimeoutException("Failed to connect to ZooKeeper");
        }
    }

    public ZkQuickConnection(String server, int zkTimeoutMillis, int connectTimeoutMillis) throws IOException, InterruptedException, TimeoutException {
        this(new BasicZooKeeperFactory(server, zkTimeoutMillis), connectTimeoutMillis);
    }

    public ZkQuickConnection(String server, int zkTimeoutMillis) throws IOException, InterruptedException, TimeoutException {
        this(server, zkTimeoutMillis, 10000);
    }

    public ZooKeeperIface getZk() {
        return this.zk;
    }

    public void close() throws InterruptedException {
        this.zk.close();
    }
}

