/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.convenience;

import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.convenience.ZkQuickConnectionManager;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public abstract class ZkScript {
    private final ZkQuickConnectionManager zkQuickConnectionManager;

    protected ZkScript(ZkQuickConnectionManager zkQuickConnectionManager) {
        this.zkQuickConnectionManager = zkQuickConnectionManager;
    }

    public void connect(String server, int timeout) throws IOException, InterruptedException, TimeoutException {
        this.zkQuickConnectionManager.connect(server, timeout);
    }

    public void close() throws InterruptedException {
        this.zkQuickConnectionManager.close();
    }

    protected ZooKeeperIface getZk() {
        return this.zkQuickConnectionManager.getZk();
    }

    protected abstract String getName();

    protected abstract Options getSpecificOptions();

    protected abstract boolean verifySpecificOptions(CommandLine var1);

    protected abstract void runScript(CommandLine var1) throws Exception;

    private Options getOptions() {
        Options options = new Options();
        options.addOption("s", "server", true, "Zookeeper server as host:port string");
        options.addOption("i", "tier", true, "Zookeeper SMC tier name (alternative to server parameter)");
        options.addOption("t", "timeout", true, "Session timeout in milliseconds [Default: 5000]");
        options.addOption("h", "help", false, "Prints this message");
        for (Option opt : this.getSpecificOptions().getOptions()) {
            options.addOption(opt);
        }
        return options;
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getName(), this.getOptions());
        System.out.println("Note: You must specify either a specific ZooKeeper server (-s) or an SMC ZooKeeper tier (-i)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMain(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        Options options = this.getOptions();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            this.printUsage();
            return;
        }
        if (!this.verifySpecificOptions(cmd)) {
            this.printUsage();
            return;
        }
        if (!cmd.hasOption("server")) {
            System.err.println("You did not specify a ZooKeeper server or an SMC ZooKeeper tier!");
            this.printUsage();
            return;
        }
        String servers = cmd.getOptionValue("server");
        int timeout = Integer.parseInt(cmd.getOptionValue("timeout", "5000"));
        this.connect(servers, timeout);
        try {
            this.runScript(cmd);
        }
        finally {
            this.close();
        }
    }
}

