/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.election;

import com.facebook.concurrency.ErrorLoggingRunnable;
import com.facebook.concurrency.NamedThreadFactory;
import com.facebook.zookeeper.Encodable;
import com.facebook.zookeeper.ZkUtil;
import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.connection.ZkConnectionManager;
import com.facebook.zookeeper.election.LeaderElection;
import com.facebook.zookeeper.election.LeaderElectionCallback;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLeaderElection
implements LeaderElection {
    private static final Logger LOG = LoggerFactory.getLogger(ZkLeaderElection.class);
    private final ZkConnectionManager zkConnectionManager;
    private final PathFormat pathFormat;
    private final Candidate candidate;
    private final PredecessorMonitor predecessorMonitor = new PredecessorMonitor();
    private final LeaderElectionCallback leaderElectionCallback;
    private final ExecutorService watchExecutor;

    public ZkLeaderElection(ZkConnectionManager zkConnectionManager, String electionPath, String baseCandidateName, Encodable candidatePayload, LeaderElectionCallback leaderElectionCallback, ExecutorService watchExecutor) {
        this.zkConnectionManager = zkConnectionManager;
        this.pathFormat = new PathFormat(electionPath, baseCandidateName);
        this.candidate = new Candidate(candidatePayload);
        this.leaderElectionCallback = leaderElectionCallback;
        this.watchExecutor = watchExecutor;
    }

    public ZkLeaderElection(ZkConnectionManager zkConnectionManager, String electionPath, String baseCandidateName, Encodable candidatePayload, LeaderElectionCallback leaderElectionCallback) {
        this(zkConnectionManager, electionPath, baseCandidateName, candidatePayload, leaderElectionCallback, Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("ZkLeaderElection-watch")));
    }

    @Override
    public void enter() throws InterruptedException, KeeperException {
        this.candidate.enter();
    }

    @Override
    public void withdraw() throws InterruptedException, KeeperException {
        this.candidate.withdraw();
    }

    @Override
    public void cycle() throws InterruptedException, KeeperException {
        this.candidate.cycle();
    }

    @Override
    public String getLeader() throws InterruptedException, KeeperException {
        ZooKeeperIface zk = this.zkConnectionManager.getClient();
        List<String> candidateNames = this.getCandidateNames(zk);
        long leaderSeqNo = Long.MAX_VALUE;
        String leader = null;
        for (String candidateName : candidateNames) {
            long candidateSeqNo = this.pathFormat.extractSeqNo(candidateName);
            if (candidateSeqNo >= leaderSeqNo) continue;
            leader = candidateName;
            leaderSeqNo = candidateSeqNo;
        }
        return leader;
    }

    private boolean setWatchIfNodeExists(ZooKeeperIface zk, String path, Watcher watcher) throws InterruptedException, KeeperException {
        try {
            zk.getData(path, watcher, null);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
    }

    private String findCandidateName(long sessionId, List<String> candidateNames) {
        for (String candidateName : candidateNames) {
            if (sessionId != this.pathFormat.extractSessionId(candidateName)) continue;
            return candidateName;
        }
        return null;
    }

    private List<String> getCandidateNames(ZooKeeperIface zk) throws InterruptedException, KeeperException {
        List<String> children = zk.getChildren(this.pathFormat.getElectionPath(), false);
        return this.pathFormat.filterByBaseName(children);
    }

    private class PredecessorMonitor {
        private final PredecessorWatcher predecessorWatcher = new PredecessorWatcher();

        private PredecessorMonitor() {
        }

        public void monitor(ZooKeeperIface zk) throws InterruptedException, KeeperException {
            String predecessor;
            String predecessorPath;
            do {
                List candidateNames = ZkLeaderElection.this.getCandidateNames(zk);
                if (ZkLeaderElection.this.findCandidateName(zk.getSessionId(), candidateNames) == null) break;
                predecessor = this.findPrecedingCandidateName(zk.getSessionId(), candidateNames);
                if (predecessor != null) continue;
                ZkLeaderElection.this.leaderElectionCallback.elected();
                break;
            } while (!ZkLeaderElection.this.setWatchIfNodeExists(zk, predecessorPath = ZkLeaderElection.this.pathFormat.buildPath(predecessor), this.predecessorWatcher));
        }

        private String findPrecedingCandidateName(long sessionId, List<String> candidateNames) {
            String thisCandidateName = ZkLeaderElection.this.findCandidateName(sessionId, candidateNames);
            assert (thisCandidateName != null);
            long thisSeqNo = ZkLeaderElection.this.pathFormat.extractSeqNo(thisCandidateName);
            long closestPrecedingSeqNo = -1L;
            String closestPrecedingCandidateName = null;
            for (String candidateName : candidateNames) {
                long candidateSeqNo = ZkLeaderElection.this.pathFormat.extractSeqNo(candidateName);
                if (candidateSeqNo >= thisSeqNo || candidateSeqNo <= closestPrecedingSeqNo) continue;
                closestPrecedingSeqNo = candidateSeqNo;
                closestPrecedingCandidateName = candidateName;
            }
            return closestPrecedingCandidateName;
        }

        private class PredecessorWatcher
        implements Watcher {
            private PredecessorWatcher() {
            }

            public void process(final WatchedEvent event) {
                ZkLeaderElection.this.watchExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getType() != Watcher.Event.EventType.None) {
                            try {
                                ZooKeeperIface zk = ZkLeaderElection.this.zkConnectionManager.getClient();
                                PredecessorMonitor.this.monitor(zk);
                            }
                            catch (Exception e) {
                                ZkLeaderElection.this.leaderElectionCallback.error(e);
                            }
                        }
                    }
                }));
            }
        }
    }

    private class Candidate {
        private final Encodable candidatePayload;
        private volatile CandidateWatcher currentCandidateWatcher = null;

        private Candidate(Encodable candidatePayload) {
            this.candidatePayload = candidatePayload;
        }

        public synchronized void enter() throws InterruptedException, KeeperException {
            ZooKeeperIface zk = ZkLeaderElection.this.zkConnectionManager.getClient();
            this.internalEnter(zk);
        }

        private void internalEnter(ZooKeeperIface zk) throws InterruptedException, KeeperException {
            String candidatePath = this.createCandidateNodeSafe(zk);
            if (this.currentCandidateWatcher == null || !this.currentCandidateWatcher.appliesTo(candidatePath)) {
                this.currentCandidateWatcher = new CandidateWatcher(candidatePath);
            }
            if (!ZkLeaderElection.this.setWatchIfNodeExists(zk, candidatePath, this.currentCandidateWatcher)) {
                ZkLeaderElection.this.leaderElectionCallback.removed();
                return;
            }
            ZkLeaderElection.this.predecessorMonitor.monitor(zk);
            LOG.info("entering election for path " + candidatePath);
        }

        public synchronized void withdraw() throws InterruptedException, KeeperException {
            ZooKeeperIface zk = ZkLeaderElection.this.zkConnectionManager.getClient();
            this.internalWithdraw(zk);
        }

        private void internalWithdraw(ZooKeeperIface zk) throws InterruptedException, KeeperException {
            block4: {
                if (this.currentCandidateWatcher != null) {
                    this.currentCandidateWatcher.ignoreOneDelete();
                }
                List candidateNames = ZkLeaderElection.this.getCandidateNames(zk);
                String candidateName = ZkLeaderElection.this.findCandidateName(zk.getSessionId(), candidateNames);
                if (candidateName != null) {
                    try {
                        String path = ZkLeaderElection.this.pathFormat.buildPath(candidateName);
                        zk.delete(path, -1);
                        LOG.info("withdrawing for path " + path);
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (this.currentCandidateWatcher == null) break block4;
                        this.currentCandidateWatcher.unsetIgnoreOneDelete();
                    }
                }
            }
        }

        public synchronized void cycle() throws InterruptedException, KeeperException {
            ZooKeeperIface zk = ZkLeaderElection.this.zkConnectionManager.getClient();
            this.internalWithdraw(zk);
            this.internalEnter(zk);
        }

        private String createCandidateNodeSafe(ZooKeeperIface zk) throws InterruptedException, KeeperException {
            List candidateNames = ZkLeaderElection.this.getCandidateNames(zk);
            String candidateName = ZkLeaderElection.this.findCandidateName(zk.getSessionId(), candidateNames);
            if (candidateName != null) {
                return ZkLeaderElection.this.pathFormat.buildPath(candidateName);
            }
            return zk.create(ZkLeaderElection.this.pathFormat.buildCandidatePathPrefix(zk.getSessionId()), this.candidatePayload.encode(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        }

        private class CandidateWatcher
        implements Watcher {
            private final String candidatePath;
            private volatile boolean ignoreOneDelete = false;

            private CandidateWatcher(String candidatePath) {
                this.candidatePath = candidatePath;
            }

            public boolean appliesTo(String path) {
                return this.candidatePath.equals(path);
            }

            public void ignoreOneDelete() {
                this.ignoreOneDelete = true;
            }

            public void unsetIgnoreOneDelete() {
                this.ignoreOneDelete = false;
            }

            public void process(final WatchedEvent event) {
                ZkLeaderElection.this.watchExecutor.execute((Runnable)new ErrorLoggingRunnable(new Runnable(){

                    @Override
                    public void run() {
                        switch (event.getState()) {
                            case SyncConnected: {
                                CandidateWatcher.this.processNodeEvent(event.getType());
                                break;
                            }
                            case Expired: {
                                ZkLeaderElection.this.leaderElectionCallback.removed();
                            }
                        }
                    }
                }));
            }

            private void processNodeEvent(Watcher.Event.EventType eventType) {
                switch (eventType) {
                    case NodeDeleted: {
                        if (!this.ignoreOneDelete) {
                            ZkLeaderElection.this.leaderElectionCallback.removed();
                        }
                        this.ignoreOneDelete = false;
                        break;
                    }
                    case NodeChildrenChanged: 
                    case NodeCreated: 
                    case NodeDataChanged: {
                        try {
                            ZooKeeperIface zk = ZkLeaderElection.this.zkConnectionManager.getClient();
                            if (ZkLeaderElection.this.setWatchIfNodeExists(zk, this.candidatePath, this)) break;
                            ZkLeaderElection.this.leaderElectionCallback.removed();
                            break;
                        }
                        catch (Exception e) {
                            ZkLeaderElection.this.leaderElectionCallback.error(e);
                        }
                    }
                }
            }
        }
    }

    private class PathFormat {
        private static final char NAME_DELIM = '-';
        private final String electionPath;
        private final String baseCandidateName;

        private PathFormat(String electionPath, String baseCandidateName) {
            this.electionPath = electionPath;
            this.baseCandidateName = baseCandidateName;
        }

        public String getElectionPath() {
            return this.electionPath;
        }

        public String buildCandidatePrefix(long sessionId) {
            return this.baseCandidateName + '-' + sessionId + '-';
        }

        public String buildPath(String candidateName) {
            return this.electionPath + "/" + candidateName;
        }

        public String buildCandidatePathPrefix(long sessionId) {
            return this.buildPath(this.buildCandidatePrefix(sessionId));
        }

        public long extractSessionId(String candidateName) {
            int startDelimIdx = candidateName.indexOf(45);
            assert (startDelimIdx != -1);
            int endDelimIdx = candidateName.lastIndexOf(45);
            assert (endDelimIdx != -1);
            assert (startDelimIdx != endDelimIdx);
            String sessionString = candidateName.substring(startDelimIdx + 1, endDelimIdx);
            return Long.parseLong(sessionString);
        }

        public long extractSeqNo(String candidateName) {
            int delimIdx = candidateName.lastIndexOf(45);
            assert (delimIdx != -1);
            String seqString = candidateName.substring(delimIdx + 1);
            return Long.parseLong(seqString);
        }

        public List<String> filterByBaseName(List<String> nodes) {
            return ZkUtil.filterByPrefix(nodes, this.baseCandidateName + '-');
        }
    }
}

