/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.mock;

import com.facebook.zookeeper.ZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.connection.ZkConnectionManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class MockZkConnectionManager
implements ZkConnectionManager {
    private final ZooKeeperFactory zooKeeperFactory;
    private ZooKeeperIface zk;
    private final List<Watcher> watchers = new ArrayList<Watcher>();
    private boolean isShutdown = false;

    public MockZkConnectionManager(ZooKeeperFactory zooKeeperFactory) {
        this.zooKeeperFactory = zooKeeperFactory;
        this.refreshClient();
    }

    public void refreshClient() {
        try {
            if (this.zk != null) {
                this.zk.close();
            }
            this.zk = this.zooKeeperFactory.create(new Watcher(){

                public void process(WatchedEvent event) {
                    for (Watcher watcher : MockZkConnectionManager.this.watchers) {
                        watcher.process(event);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ZooKeeperIface getClient() throws InterruptedException {
        if (this.isShutdown) {
            throw new IllegalStateException("Already shutdown");
        }
        return this.zk;
    }

    @Override
    public ZooKeeper.States registerWatcher(Watcher watcher) {
        this.watchers.add(watcher);
        return this.zk.getState();
    }

    @Override
    public void shutdown() throws InterruptedException {
        if (this.isShutdown) {
            throw new IllegalStateException("Multiple shutdowns");
        }
        this.isShutdown = true;
    }
}

