/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.mock;

import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.mock.MockZooKeeperDataStore;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class MockZooKeeper
implements ZooKeeperIface {
    private final MockZooKeeperDataStore dataStore;
    private final long sessionId;
    private final Watcher defaultWatcher;
    private ZooKeeper.States state = ZooKeeper.States.CONNECTING;

    public MockZooKeeper(Watcher watcher, MockZooKeeperDataStore dataStore) {
        this.dataStore = dataStore;
        this.sessionId = dataStore.getUniqueSessionId();
        this.defaultWatcher = watcher;
    }

    public synchronized void triggerConnect() {
        this.state = ZooKeeper.States.CONNECTED;
        WatchedEvent watchedEvent = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null);
        this.dataStore.signalSessionEvent(this.sessionId, watchedEvent);
        this.defaultWatcher.process(watchedEvent);
    }

    public synchronized void triggerDisconnect() {
        this.state = ZooKeeper.States.CONNECTING;
        WatchedEvent watchedEvent = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null);
        this.dataStore.signalSessionEvent(this.sessionId, watchedEvent);
        this.defaultWatcher.process(watchedEvent);
    }

    public synchronized void triggerSessionExpiration() {
        this.state = ZooKeeper.States.CLOSED;
        WatchedEvent watchedEvent = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null);
        this.dataStore.signalSessionEvent(this.sessionId, watchedEvent);
        this.defaultWatcher.process(watchedEvent);
        this.dataStore.clearSession(this.sessionId);
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public synchronized void close() throws InterruptedException {
        this.state = ZooKeeper.States.CLOSED;
        this.dataStore.clearSession(this.sessionId);
    }

    private void verifyConnected() throws KeeperException {
        if (this.state == ZooKeeper.States.CLOSED) {
            throw new KeeperException.SessionExpiredException();
        }
        if (this.state != ZooKeeper.States.CONNECTED) {
            throw new KeeperException.ConnectionLossException();
        }
    }

    @Override
    public synchronized String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        this.verifyConnected();
        return this.dataStore.create(this.sessionId, path, data, acl, createMode);
    }

    @Override
    public synchronized void delete(String path, int expectedVersion) throws InterruptedException, KeeperException {
        this.verifyConnected();
        this.dataStore.delete(path, expectedVersion);
    }

    @Override
    public synchronized Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.verifyConnected();
        return this.dataStore.exists(this.sessionId, path, watcher);
    }

    @Override
    public synchronized Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.exists(path, watch ? this.defaultWatcher : null);
    }

    @Override
    public synchronized byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        this.verifyConnected();
        return this.dataStore.getData(this.sessionId, path, watcher, stat);
    }

    @Override
    public synchronized byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.getData(path, watch ? this.defaultWatcher : null, stat);
    }

    @Override
    public synchronized Stat setData(String path, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        this.verifyConnected();
        return this.dataStore.setData(path, data, expectedVersion);
    }

    @Override
    public synchronized List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.verifyConnected();
        return this.dataStore.getChildren(this.sessionId, path, watcher);
    }

    @Override
    public synchronized List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.getChildren(path, watch ? this.defaultWatcher : null);
    }

    @Override
    public synchronized ZooKeeper.States getState() {
        return this.state;
    }
}

