/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.mock;

import com.facebook.collections.RetrieveableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;

public class MockZooKeeperDataStore {
    private final AtomicLong nextSessionId = new AtomicLong(0L);
    private final ZNode root = ZNode.createRoot();
    private final Map<String, RetrieveableSet<ContextedWatcher>> creationWatchers = new HashMap<String, RetrieveableSet<ContextedWatcher>>();

    public long getUniqueSessionId() {
        return this.nextSessionId.addAndGet(1L);
    }

    public synchronized void signalSessionEvent(long sessionId, WatchedEvent watchedEvent) {
        for (RetrieveableSet<ContextedWatcher> pathWatchers : this.creationWatchers.values()) {
            for (ContextedWatcher contextedWatcher : pathWatchers) {
                if (contextedWatcher.getSessionId() != sessionId) continue;
                contextedWatcher.process(watchedEvent);
            }
        }
        for (ZNode zNode : this.root) {
            zNode.signalSessionEvent(sessionId, watchedEvent);
        }
    }

    public synchronized void clearSession(long sessionId) {
        for (RetrieveableSet<ContextedWatcher> pathWatchers : this.creationWatchers.values()) {
            Iterator iter = pathWatchers.iterator();
            while (iter.hasNext()) {
                ContextedWatcher contextedWatcher = (ContextedWatcher)iter.next();
                if (contextedWatcher.getSessionId() != sessionId) continue;
                iter.remove();
            }
        }
        for (ZNode zNode : this.root) {
            zNode.clearSession(sessionId);
        }
    }

    public synchronized String create(long sessionId, String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException {
        if (MockZooKeeperDataStore.isRootPath(path)) {
            throw new KeeperException.NodeExistsException(path);
        }
        String relativePath = MockZooKeeperDataStore.stripRootFromPath(path);
        String relativeChildPath = this.root.createDescendant(sessionId, relativePath, data, acl, createMode);
        String absChildPath = MockZooKeeperDataStore.addRootToPath(relativeChildPath);
        if (this.creationWatchers.containsKey(absChildPath)) {
            WatchedEvent watchedEvent = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, absChildPath);
            for (Watcher watcher : this.creationWatchers.get(absChildPath)) {
                watcher.process(watchedEvent);
            }
            this.creationWatchers.remove(absChildPath);
        }
        return absChildPath;
    }

    public synchronized void delete(String path, int expectedVersion) throws KeeperException {
        if (MockZooKeeperDataStore.isRootPath(path)) {
            throw new KeeperException.BadArgumentsException(path);
        }
        String relativePath = MockZooKeeperDataStore.stripRootFromPath(path);
        this.root.deleteDescendant(relativePath, expectedVersion);
    }

    public synchronized Stat exists(long sessionId, String path, Watcher watcher) throws KeeperException {
        try {
            ZNode node;
            ZNode zNode = node = MockZooKeeperDataStore.isRootPath(path) ? this.root : this.root.findDescendant(MockZooKeeperDataStore.stripRootFromPath(path));
            if (watcher != null) {
                node.addWatcher(sessionId, watcher, WatchTriggerPolicy.WatchType.EXISTS);
            }
            Stat stat = new Stat();
            DataTree.copyStat((Stat)node.getStat(), (Stat)stat);
            return stat;
        }
        catch (KeeperException.NoNodeException e) {
            if (watcher != null) {
                if (!this.creationWatchers.containsKey(path)) {
                    this.creationWatchers.put(path, (RetrieveableSet<ContextedWatcher>)new RetrieveableSet());
                }
                ContextedWatcher contextedWatcher = new ContextedWatcher(watcher, sessionId, WatchTriggerPolicy.WatchType.EXISTS);
                if (!this.creationWatchers.get(path).contains((Object)contextedWatcher)) {
                    this.creationWatchers.get(path).add((Object)contextedWatcher);
                }
            }
            return null;
        }
    }

    public synchronized byte[] getData(long sessionId, String path, Watcher watcher, Stat stat) throws KeeperException {
        ZNode node;
        ZNode zNode = node = MockZooKeeperDataStore.isRootPath(path) ? this.root : this.root.findDescendant(MockZooKeeperDataStore.stripRootFromPath(path));
        if (watcher != null) {
            node.addWatcher(sessionId, watcher, WatchTriggerPolicy.WatchType.GETDATA);
        }
        if (stat != null) {
            DataTree.copyStat((Stat)node.getStat(), (Stat)stat);
        }
        return node.getData();
    }

    public synchronized Stat setData(String path, byte[] data, int expectedVersion) throws KeeperException {
        ZNode node = MockZooKeeperDataStore.isRootPath(path) ? this.root : this.root.findDescendant(MockZooKeeperDataStore.stripRootFromPath(path));
        node.setData(data, expectedVersion);
        Stat stat = new Stat();
        DataTree.copyStat((Stat)node.getStat(), (Stat)stat);
        return stat;
    }

    public synchronized List<String> getChildren(long sessionId, String path, Watcher watcher) throws KeeperException {
        ZNode node;
        ZNode zNode = node = MockZooKeeperDataStore.isRootPath(path) ? this.root : this.root.findDescendant(MockZooKeeperDataStore.stripRootFromPath(path));
        if (watcher != null) {
            node.addWatcher(sessionId, watcher, WatchTriggerPolicy.WatchType.GETCHILDREN);
        }
        return new ArrayList<String>(node.getChildren().keySet());
    }

    private static boolean isRootPath(String path) {
        return path.equals("/");
    }

    private static String stripRootFromPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Does not have root: " + path);
        }
        return path.substring(1);
    }

    private static String addRootToPath(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Already has root: " + path);
        }
        return "/" + path;
    }

    private static class WatchTriggerPolicy {
        private static Map<WatchType, Set<Watcher.Event.EventType>> mapping = WatchTriggerPolicy.constructMapping();

        private WatchTriggerPolicy() {
        }

        private static Map<WatchType, Set<Watcher.Event.EventType>> constructMapping() {
            EnumMap<WatchType, Set<Watcher.Event.EventType>> mapping = new EnumMap<WatchType, Set<Watcher.Event.EventType>>(WatchType.class);
            mapping.put(WatchType.EXISTS, EnumSet.of(Watcher.Event.EventType.NodeCreated, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeDataChanged));
            mapping.put(WatchType.GETDATA, EnumSet.of(Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeDataChanged));
            mapping.put(WatchType.GETCHILDREN, EnumSet.of(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted));
            return mapping;
        }

        public static boolean shouldTrigger(WatchType watchType, Watcher.Event.EventType eventType) {
            return mapping.get((Object)watchType).contains(eventType);
        }

        private static enum WatchType {
            EXISTS,
            GETDATA,
            GETCHILDREN;

        }
    }

    private static class ContextedWatcher
    implements Watcher {
        private final Watcher watcher;
        private final WatchContext watchContext;

        private ContextedWatcher(Watcher watcher, long sessionId, WatchTriggerPolicy.WatchType watchType) {
            this.watcher = watcher;
            this.watchContext = new WatchContext(sessionId, watchType);
        }

        public long getSessionId() {
            return this.watchContext.getSessionId();
        }

        public boolean shouldTrigger(Watcher.Event.EventType eventType) {
            return this.watchContext.shouldTrigger(eventType);
        }

        public void merge(ContextedWatcher contextedWatcher) {
            assert (this.watcher.equals(contextedWatcher.watcher));
            this.watchContext.merge(contextedWatcher.watchContext);
        }

        public void process(WatchedEvent event) {
            this.watcher.process(event);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContextedWatcher)) {
                return false;
            }
            ContextedWatcher that = (ContextedWatcher)o;
            return this.watcher.equals(that.watcher);
        }

        public int hashCode() {
            return this.watcher.hashCode();
        }

        private static class WatchContext {
            private final Set<WatchTriggerPolicy.WatchType> watchTypeSet = EnumSet.noneOf(WatchTriggerPolicy.WatchType.class);
            private long sessionId;

            private WatchContext(long sessionId, WatchTriggerPolicy.WatchType watchType) {
                this.sessionId = sessionId;
                this.watchTypeSet.add(watchType);
            }

            public long getSessionId() {
                return this.sessionId;
            }

            public boolean shouldTrigger(Watcher.Event.EventType eventType) {
                for (WatchTriggerPolicy.WatchType watchType : this.watchTypeSet) {
                    if (!WatchTriggerPolicy.shouldTrigger(watchType, eventType)) continue;
                    return true;
                }
                return false;
            }

            public void merge(WatchContext watchContext) {
                assert (this.sessionId == watchContext.getSessionId());
                this.watchTypeSet.addAll(watchContext.watchTypeSet);
            }
        }
    }

    private static class ZNode
    implements Iterable<ZNode> {
        private final ZNode parent;
        private final String name;
        private byte[] data;
        private List<ACL> acl;
        private final CreateMode createMode;
        private final Stat stat = new Stat();
        private final AtomicLong nextSeqNum = new AtomicLong(0L);
        private final AtomicInteger version = new AtomicInteger(0);
        private final Map<String, ZNode> children = new HashMap<String, ZNode>();
        private final RetrieveableSet<ContextedWatcher> contextedWatchers = new RetrieveableSet();

        private ZNode(long sessionId, ZNode parent, String name, byte[] data, List<ACL> acl, CreateMode createMode) {
            this.parent = parent;
            this.name = name;
            this.data = data;
            this.acl = acl;
            this.createMode = createMode;
            this.stat.setEphemeralOwner(createMode.isEphemeral() ? sessionId : 0L);
            this.stat.setDataLength(data == null ? 0 : data.length);
            this.stat.setNumChildren(0);
            this.stat.setVersion(this.version.get());
        }

        public static ZNode createRoot() {
            return new ZNode(0L, null, "", new byte[0], null, CreateMode.PERSISTENT);
        }

        public void addWatcher(long sessionId, Watcher watcher, WatchTriggerPolicy.WatchType watchType) {
            ContextedWatcher contextedWatcher = new ContextedWatcher(watcher, sessionId, watchType);
            if (this.contextedWatchers.contains((Object)contextedWatcher)) {
                ((ContextedWatcher)this.contextedWatchers.get((Object)contextedWatcher)).merge(contextedWatcher);
            } else {
                this.contextedWatchers.add((Object)contextedWatcher);
            }
        }

        public void clearSession(long sessionId) {
            Iterator iter = this.contextedWatchers.iterator();
            while (iter.hasNext()) {
                if (((ContextedWatcher)iter.next()).getSessionId() != sessionId) continue;
                iter.remove();
            }
            if (this.stat.getEphemeralOwner() == sessionId) {
                try {
                    this.delete(-1);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void signalSessionEvent(long sessionId, WatchedEvent watchedEvent) {
            for (ContextedWatcher contextedWatcher : this.contextedWatchers) {
                if (contextedWatcher.getSessionId() != sessionId) continue;
                contextedWatcher.process(watchedEvent);
            }
        }

        public void signalNodeEvent(Watcher.Event.EventType eventType) {
            assert (eventType != Watcher.Event.EventType.None);
            WatchedEvent watchedEvent = new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, MockZooKeeperDataStore.addRootToPath(this.getPath()));
            Iterator iter = this.contextedWatchers.iterator();
            while (iter.hasNext()) {
                ContextedWatcher contextedWatcher = (ContextedWatcher)iter.next();
                if (!contextedWatcher.shouldTrigger(eventType)) continue;
                iter.remove();
                contextedWatcher.process(watchedEvent);
            }
        }

        public ZNode findDescendant(String path) throws KeeperException {
            List<String> pathParts = Arrays.asList(path.split("/"));
            ZNode lastSeenZNode = this;
            for (String childName : pathParts) {
                if ((lastSeenZNode = lastSeenZNode.getChildren().get(childName)) != null) continue;
                throw new KeeperException.NoNodeException();
            }
            return lastSeenZNode;
        }

        public ZNode findLeafParent(String path) throws KeeperException {
            if (!path.contains("/")) {
                return this;
            }
            return this.findDescendant(ZNode.getLeafParentPath(path));
        }

        private static String getLeafParentPath(String path) {
            int idx = path.lastIndexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("Path does not have parent: " + path);
            }
            return path.substring(0, idx);
        }

        public String getPath() {
            ZNode currentNode = this;
            String path = "";
            while (!currentNode.isRoot()) {
                if (!path.isEmpty()) {
                    path = "/" + path;
                }
                path = currentNode.getName() + path;
                currentNode = currentNode.getParent();
            }
            return path;
        }

        private static String getLeafName(String path) {
            int idx = path.lastIndexOf("/");
            if (idx == -1) {
                return path;
            }
            return path.substring(idx + 1);
        }

        public String createDescendant(long sessionId, String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException {
            ZNode parent = this.findLeafParent(path);
            String childName = parent.createChild(sessionId, ZNode.getLeafName(path), data, acl, createMode);
            return parent.isRoot() ? childName : parent.getPath() + "/" + childName;
        }

        public String createChild(long sessionId, String childName, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException {
            if (createMode.isSequential()) {
                childName = childName + String.format("%08d", this.nextSeqNum.addAndGet(1L));
            }
            ZNode zNode = new ZNode(sessionId, this, childName, data, acl, createMode);
            this.addChild(zNode);
            zNode.signalNodeEvent(Watcher.Event.EventType.NodeCreated);
            return childName;
        }

        public void addChild(ZNode zNode) throws KeeperException {
            if (this.createMode.isEphemeral()) {
                throw new KeeperException.NoChildrenForEphemeralsException();
            }
            if (this.children.containsKey(zNode.getName())) {
                throw new KeeperException.NodeExistsException();
            }
            this.children.put(zNode.getName(), zNode);
            this.stat.setNumChildren(this.children.size());
            this.signalNodeEvent(Watcher.Event.EventType.NodeChildrenChanged);
        }

        public void deleteDescendant(String path, int expectedVersion) throws KeeperException {
            this.findDescendant(path).delete(expectedVersion);
        }

        public void delete(int expectedVersion) throws KeeperException {
            assert (!this.isRoot());
            if (!this.getChildren().isEmpty()) {
                throw new KeeperException.NotEmptyException();
            }
            if (expectedVersion != -1 && this.getStat().getVersion() != expectedVersion) {
                throw new KeeperException.BadVersionException();
            }
            if (this.getParent().children.remove(this.getName()) == null) {
                throw new KeeperException.NoNodeException();
            }
            this.signalNodeEvent(Watcher.Event.EventType.NodeDeleted);
            this.getParent().signalNodeEvent(Watcher.Event.EventType.NodeChildrenChanged);
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public ZNode getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] newData, int expectedVersion) throws KeeperException {
            if (expectedVersion != -1 && this.getStat().getVersion() != expectedVersion) {
                throw new KeeperException.BadVersionException();
            }
            this.data = newData;
            this.stat.setDataLength(newData == null ? 0 : newData.length);
            this.stat.setVersion(this.version.addAndGet(1));
            this.signalNodeEvent(Watcher.Event.EventType.NodeDataChanged);
        }

        public List<ACL> getAcl() {
            return Collections.unmodifiableList(this.acl);
        }

        public Stat getStat() {
            return this.stat;
        }

        public Map<String, ZNode> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        @Override
        public Iterator<ZNode> iterator() {
            return new ZNodeTreeIterator(this);
        }

        private static class ZNodeTreeIterator
        implements Iterator<ZNode> {
            private boolean selfReturned = false;
            private ZNode initialZNode;
            private Iterator<ZNode> childIter;
            private Iterator<ZNode> childTreeIter;
            private ZNode currentZNode;

            private ZNodeTreeIterator(ZNode initialZNode) {
                this.initialZNode = initialZNode;
                ArrayList<ZNode> childrenCopy = new ArrayList<ZNode>(initialZNode.getChildren().values());
                this.childIter = childrenCopy.iterator();
            }

            @Override
            public boolean hasNext() {
                if (!this.selfReturned) {
                    return true;
                }
                if (this.childIter.hasNext()) {
                    return true;
                }
                return this.childTreeIter != null && this.childTreeIter.hasNext();
            }

            @Override
            public ZNode next() {
                if (!this.selfReturned) {
                    this.selfReturned = true;
                    this.currentZNode = this.initialZNode;
                    return this.initialZNode;
                }
                if (this.childTreeIter == null || !this.childTreeIter.hasNext()) {
                    this.childTreeIter = this.childIter.next().iterator();
                }
                this.currentZNode = this.childTreeIter.next();
                return this.currentZNode;
            }

            @Override
            public void remove() {
                try {
                    this.currentZNode.delete(-1);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

