/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.mock;

import com.facebook.zookeeper.ZooKeeperFactory;
import com.facebook.zookeeper.ZooKeeperIface;
import com.facebook.zookeeper.mock.MockZooKeeper;
import com.facebook.zookeeper.mock.MockZooKeeperDataStore;
import java.io.IOException;
import org.apache.zookeeper.Watcher;

public class MockZooKeeperFactory
implements ZooKeeperFactory {
    private final MockZooKeeperDataStore dataStore;
    private MockZooKeeper lastZk;
    private boolean throwOnNextCreate = false;
    private boolean autoConnect = false;

    public MockZooKeeperFactory(MockZooKeeperDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public MockZooKeeper getLastZooKeeper() {
        return this.lastZk;
    }

    public void throwOnNextCreate() {
        this.throwOnNextCreate = true;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    @Override
    public ZooKeeperIface create(Watcher watcher) throws IOException {
        if (this.throwOnNextCreate) {
            this.throwOnNextCreate = false;
            throw new IOException();
        }
        this.lastZk = new MockZooKeeper(watcher, this.dataStore);
        if (this.autoConnect) {
            this.lastZk.triggerConnect();
        }
        return this.lastZk;
    }
}

