/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.path;

import com.facebook.zookeeper.path.ZkPathCore;
import com.facebook.zookeeper.path.ZkPathCoreBuilder;
import java.util.Iterator;

public class ZkGenericPath {
    private final ZkPathCore pathCore;

    public ZkGenericPath(String appRoot) {
        this(new ZkPathCore(appRoot));
    }

    private ZkGenericPath(ZkPathCore pathCore) {
        this.pathCore = pathCore;
    }

    public static ZkGenericPath parse(String appRoot, String fullPath) {
        return new ZkGenericPath(new ZkPathCoreBuilder(appRoot).parse(fullPath).build());
    }

    public boolean isRoot() {
        return this.pathCore.getZNodes().isEmpty();
    }

    public ZkGenericPath getParent() {
        if (this.pathCore.getZNodes().isEmpty()) {
            throw new IllegalStateException("No more parents");
        }
        return new ZkGenericPath(new ZkPathCoreBuilder(this.pathCore).remove().build());
    }

    public ZkGenericPath appendChild(String child) {
        return new ZkGenericPath(new ZkPathCoreBuilder(this.pathCore).append(child).build());
    }

    public Iterator<ZkGenericPath> lineageIterator() {
        return new LineageIterator();
    }

    public String toString() {
        return this.pathCore.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZkGenericPath)) {
            return false;
        }
        ZkGenericPath that = (ZkGenericPath)o;
        return this.pathCore.equals(that.pathCore);
    }

    public int hashCode() {
        return this.pathCore.hashCode();
    }

    private class LineageIterator
    implements Iterator<ZkGenericPath> {
        private final Iterator<String> nodeIter;
        private boolean appRootReturned;
        private ZkGenericPath previousPath;

        private LineageIterator() {
            this.nodeIter = ZkGenericPath.this.pathCore.getZNodes().iterator();
            this.appRootReturned = false;
        }

        @Override
        public boolean hasNext() {
            return !this.appRootReturned || this.nodeIter.hasNext();
        }

        @Override
        public ZkGenericPath next() {
            if (!this.appRootReturned) {
                this.appRootReturned = true;
                this.previousPath = new ZkGenericPath(ZkGenericPath.this.pathCore.getAppRoot());
                return this.previousPath;
            }
            this.previousPath = this.previousPath.appendChild(this.nodeIter.next());
            return this.previousPath;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

