/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.path;

import java.util.Collections;
import java.util.List;

public class ZkPathCore {
    private final String appRoot;
    private final List<String> zNodes;
    private final String pathStr;

    ZkPathCore(String appRoot, List<String> zNodes) {
        this.appRoot = appRoot;
        this.zNodes = zNodes;
        this.pathStr = this.generatePathStr();
    }

    public ZkPathCore(String appRoot) {
        this(appRoot, Collections.emptyList());
    }

    public ZkPathCore(ZkPathCore pathCore) {
        this(pathCore.appRoot, pathCore.zNodes);
    }

    public String getAppRoot() {
        return this.appRoot;
    }

    public List<String> getZNodes() {
        return Collections.unmodifiableList(this.zNodes);
    }

    public String toString() {
        return this.pathStr;
    }

    private String generatePathStr() {
        if (this.zNodes.isEmpty()) {
            return this.appRoot;
        }
        StringBuilder sb = new StringBuilder(this.computeStringLen());
        String normalizedAppRoot = this.appRoot.equals("/") ? "" : this.appRoot;
        sb.append(normalizedAppRoot);
        for (String zNode : this.zNodes) {
            sb.append("/").append(zNode);
        }
        return sb.toString();
    }

    private int computeStringLen() {
        if (this.zNodes.isEmpty()) {
            return this.appRoot.length();
        }
        String normalizedAppRoot = this.appRoot.equals("/") ? "" : this.appRoot;
        int length = normalizedAppRoot.length();
        for (String zNode : this.zNodes) {
            length += zNode.length() + 1;
        }
        return length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZkPathCore)) {
            return false;
        }
        ZkPathCore that = (ZkPathCore)o;
        if (!this.appRoot.equals(that.appRoot)) {
            return false;
        }
        return this.zNodes.equals(that.zNodes);
    }

    public int hashCode() {
        int result = this.appRoot.hashCode();
        result = 31 * result + this.zNodes.hashCode();
        return result;
    }
}

