/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.zookeeper.path;

import com.facebook.zookeeper.path.ZkPathCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ZkPathCoreBuilder {
    private final String appRoot;
    private final List<String> zNodes = new ArrayList<String>();

    public ZkPathCoreBuilder(ZkPathCore basePathCore) {
        this(basePathCore.getAppRoot());
        this.zNodes.addAll(basePathCore.getZNodes());
    }

    public ZkPathCoreBuilder(String appRoot) {
        this.appRoot = appRoot;
    }

    public ZkPathCoreBuilder parse(String fullPath) {
        if (fullPath.endsWith("/") && !fullPath.equals("/")) {
            throw new IllegalArgumentException("Invalid path: " + fullPath);
        }
        String normalizedAppRoot = this.appRoot.equals("/") ? "" : this.appRoot;
        this.zNodes.clear();
        if (fullPath.equals(this.appRoot)) {
            return this;
        }
        if (!fullPath.startsWith(normalizedAppRoot + "/")) {
            throw new IllegalArgumentException("Could not parse: " + fullPath);
        }
        String stripped = fullPath.replaceFirst(normalizedAppRoot + "/", "");
        this.zNodes.addAll(Arrays.asList(stripped.split("/")));
        return this;
    }

    public ZkPathCoreBuilder append(String zNode) {
        this.zNodes.add(zNode);
        return this;
    }

    public ZkPathCoreBuilder remove() {
        this.zNodes.remove(this.zNodes.size() - 1);
        return this;
    }

    public ZkPathCoreBuilder truncateToSize(int targetSize) {
        assert (targetSize >= 0);
        while (this.zNodes.size() > targetSize) {
            this.remove();
        }
        return this;
    }

    public ZkPathCore build() {
        return new ZkPathCore(this.appRoot, this.zNodes);
    }
}

