/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt;

import com.facebook.ktfmt.KotlinTok;
import com.facebook.ktfmt.KotlinToken;
import com.facebook.ktfmt.Tokenizer;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001dJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001a0!J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\u0016\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0010H\u0016J\b\u0010'\u001a\u00020\u0003H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0012H\u0016J\b\u0010+\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\"\u00100\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/facebook/ktfmt/KotlinInput;", "Lcom/google/googlejavaformat/Input;", "text", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "kN", "", "kToToken", "", "Lcom/google/googlejavaformat/Input$Token;", "[Lcom/google/googlejavaformat/Input$Token;", "positionToColumnMap", "Lcom/google/common/collect/ImmutableMap;", "positionTokenMap", "Lcom/google/common/collect/ImmutableRangeMap;", "tokens", "Lcom/google/common/collect/ImmutableList;", "buildTokens", "toks", "", "Lcom/facebook/ktfmt/KotlinTok;", "buildToks", "fileText", "characterRangeToTokenRange", "Lcom/google/common/collect/Range;", "offset", "length", "characterRangeToTokenRange$ktfmt", "characterRangesToTokenRanges", "Lcom/google/common/collect/RangeSet;", "characterRanges", "", "getColumnNumber", "inputPosition", "getLineNumber", "getPositionToColumnMap", "getPositionTokenMap", "getText", "getToken", "k", "getTokens", "getkN", "isParamComment", "", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "makePositionToColumnMap", "ktfmt"})
public final class KotlinInput
extends Input {
    private final ImmutableList<Input.Token> tokens;
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    private final ImmutableRangeMap<Integer, Input.Token> positionTokenMap;
    private int kN;
    private final Input.Token[] kToToken;
    private final String text;

    @NotNull
    public final RangeSet<Integer> characterRangesToTokenRanges(@NotNull Collection<Range<Integer>> characterRanges) throws FormatterException {
        Intrinsics.checkNotNullParameter(characterRanges, (String)"characterRanges");
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            Comparable comparable = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"characterRange.lowerEndpoint()");
            int n = ((Number)((Object)comparable)).intValue();
            int n2 = ((Number)((Object)characterRange.upperEndpoint())).intValue();
            Comparable comparable2 = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"characterRange.lowerEndpoint()");
            tokenRangeSet.add(this.characterRangeToTokenRange$ktfmt(n, n2 - ((Number)((Object)comparable2)).intValue()));
        }
        TreeRangeSet treeRangeSet = tokenRangeSet;
        Intrinsics.checkNotNullExpressionValue((Object)treeRangeSet, (String)"tokenRangeSet");
        return (RangeSet)treeRangeSet;
    }

    @NotNull
    public final Range<Integer> characterRangeToTokenRange$ktfmt(int offset, int length) throws FormatterException {
        Range range;
        int length2 = length;
        int requiredLength = offset + length2;
        if (requiredLength > this.text.length()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "error: invalid length %d, offset + length (%d) is outside the file";
            Object[] objectArray = new Object[]{length2, requiredLength};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new FormatterException(string2);
        }
        if (length2 < 0) {
            Range range2 = KotlinInput.access$getEMPTY_RANGE$p$s70805418();
            Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"EMPTY_RANGE");
            return range2;
        }
        if (length2 == 0) {
            length2 = 1;
        }
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getPositionTokenMap().subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + length2))).asMapOfRanges().values();
        Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"getPositionTokenMap()\n  \u2026ges()\n            .values");
        ImmutableCollection enclosed = immutableCollection;
        if (enclosed.isEmpty()) {
            Range range3 = KotlinInput.access$getEMPTY_RANGE$p$s70805418();
            range = range3;
            Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"EMPTY_RANGE");
        } else {
            Object object = enclosed.iterator().next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enclosed.iterator().next()");
            Input.Tok tok = ((Input.Token)object).getTok();
            Intrinsics.checkNotNullExpressionValue((Object)tok, (String)"enclosed.iterator().next().tok");
            Range range4 = Range.closedOpen((Comparable)Integer.valueOf(tok.getIndex()), (Comparable)Integer.valueOf(((Input.Token)Iterables.getLast((Iterable)((Iterable)enclosed))).getTok().getIndex() + 1));
            range = range4;
            Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"Range.closedOpen(\n      \u2026.getTok().getIndex() + 1)");
        }
        return range;
    }

    private final ImmutableMap<Integer, Integer> makePositionToColumnMap(List<KotlinTok> toks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (KotlinTok tok : toks) {
            builder.put((Object)tok.getPosition(), (Object)tok.getColumn());
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    private final ImmutableList<KotlinTok> buildToks(KtFile file, String fileText) {
        Tokenizer tokenizer = new Tokenizer(fileText, file);
        file.accept((PsiElementVisitor)tokenizer);
        List<KotlinTok> toks = tokenizer.getToks();
        int n = tokenizer.getIndex();
        int n2 = fileText.length();
        KtToken ktToken = KtTokens.EOF;
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"KtTokens.EOF");
        toks.add(new KotlinTok(n, "", "", n2, 0, true, ktToken));
        this.kN = tokenizer.getIndex();
        this.computeRanges(toks);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)toks);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(toks)");
        return immutableList;
    }

    private final ImmutableList<Input.Token> buildTokens(List<KotlinTok> toks) {
        ImmutableList.Builder tokens = ImmutableList.builder();
        int k = 0;
        int kN = toks.size();
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"ImmutableList.builder()");
        ImmutableList.Builder toksBefore = builder;
        block0: while (k < kN) {
            KotlinTok tok;
            while (!toks.get(k).isToken()) {
                tok = toks.get(k++);
                toksBefore.add((Object)tok);
                if (!this.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    ++k;
                }
            }
            tok = toks.get(k++);
            ImmutableList.Builder toksAfter = ImmutableList.builder();
            while (!(k >= kN || toks.get(k).isToken() || toks.get(k).isSlashStarComment() && (Intrinsics.areEqual((Object)tok.getText(), (Object)"(") || Intrinsics.areEqual((Object)tok.getText(), (Object)"<") || Intrinsics.areEqual((Object)tok.getText(), (Object)".")) || toks.get(k).isJavadocComment() && Intrinsics.areEqual((Object)tok.getText(), (Object)";"))) {
                if (this.isParamComment(toks.get(k))) {
                    ImmutableList immutableList = toksBefore.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksBefore.build()");
                    ImmutableList immutableList2 = toksAfter.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"toksAfter.build()");
                    tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList, tok, (ImmutableList<KotlinTok>)immutableList2));
                    Intrinsics.checkNotNullExpressionValue((Object)ImmutableList.builder().add((Object)toks.get(k++)), (String)"ImmutableList.builder<KotlinTok>().add(toks[k++])");
                    while (toks.get(k).isNewline()) {
                        ++k;
                    }
                    continue block0;
                }
                KotlinTok nonTokenAfter = toks.get(k++);
                toksAfter.add((Object)nonTokenAfter);
                if (!Newlines.containsBreaks((String)nonTokenAfter.getText())) continue;
                break;
            }
            ImmutableList immutableList = toksBefore.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksBefore.build()");
            ImmutableList immutableList3 = toksAfter.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList3, (String)"toksAfter.build()");
            tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList, tok, (ImmutableList<KotlinTok>)immutableList3));
            Intrinsics.checkNotNullExpressionValue((Object)ImmutableList.builder(), (String)"ImmutableList.builder()");
        }
        ImmutableList immutableList = tokens.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"tokens.build()");
        return immutableList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParamComment(Input.Tok tok) {
        if (!tok.isSlashStarComment()) return false;
        String string = tok.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tok.text");
        CharSequence charSequence = string;
        String string2 = "/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*/";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        if (!string2.matches(charSequence)) return false;
        return true;
    }

    public int getkN() {
        return this.kN;
    }

    @Nullable
    public Input.Token getToken(int k) {
        return this.kToToken[k];
    }

    @NotNull
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    @NotNull
    public ImmutableRangeMap<Integer, ? extends Input.Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @NotNull
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public int getLineNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).line + 1;
    }

    public int getColumnNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).column;
    }

    public KotlinInput(@NotNull String text, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.text = text;
        this.setLines(ImmutableList.copyOf((Iterator)Newlines.lineIterator((String)this.text)));
        ImmutableList<KotlinTok> toks = this.buildToks(file, this.text);
        this.positionToColumnMap = this.makePositionToColumnMap((List)toks);
        this.tokens = this.buildTokens((List)toks);
        ImmutableRangeMap.Builder tokenLocations = ImmutableRangeMap.builder();
        for (Input.Token token : this.tokens) {
            Input.Tok end;
            Input.Tok tok = end = JavaOutput.endTok((Input.Token)token);
            Intrinsics.checkNotNullExpressionValue((Object)tok, (String)"end");
            int upper = tok.getPosition();
            String string = end.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"end.text");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                upper += end.length() - 1;
            }
            Input.Tok tok2 = JavaOutput.startTok((Input.Token)token);
            Intrinsics.checkNotNullExpressionValue((Object)tok2, (String)"JavaOutput.startTok(token)");
            tokenLocations.put(Range.closed((Comparable)Integer.valueOf(tok2.getPosition()), (Comparable)Integer.valueOf(upper)), (Object)token);
        }
        ImmutableRangeMap immutableRangeMap = tokenLocations.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableRangeMap, (String)"tokenLocations.build()");
        this.positionTokenMap = immutableRangeMap;
        this.kToToken = new Input.Token[this.kN + 1];
        UnmodifiableIterator unmodifiableIterator = this.tokens.iterator();
        while (unmodifiableIterator.hasNext()) {
            Input.Tok tok;
            Input.Token token;
            Input.Token token2 = token = (Input.Token)unmodifiableIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"token");
            UnmodifiableIterator unmodifiableIterator2 = token2.getToksBefore().iterator();
            while (unmodifiableIterator2.hasNext()) {
                Input.Tok tok3 = tok = (Input.Tok)unmodifiableIterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)tok3, (String)"tok");
                if (tok3.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            Input.Tok tok4 = token.getTok();
            Intrinsics.checkNotNullExpressionValue((Object)tok4, (String)"token.tok");
            this.kToToken[tok4.getIndex()] = token;
            unmodifiableIterator2 = token.getToksAfter().iterator();
            while (unmodifiableIterator2.hasNext()) {
                Input.Tok tok5 = tok = (Input.Tok)unmodifiableIterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)tok5, (String)"tok");
                if (tok5.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    public static final /* synthetic */ Range access$getEMPTY_RANGE$p$s70805418() {
        return Input.EMPTY_RANGE;
    }
}

