/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormatter;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001e\u0010\u000e\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocCommentsHelper;", "Lcom/google/googlejavaformat/CommentsHelper;", "lineSeparator", "", "maxLineLength", "", "(Ljava/lang/String;I)V", "LINE_COMMENT_MISSING_SPACE_PREFIX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "indentJavadoc", "lines", "", "column0", "indentLineComments", "javadocShaped", "", "preserveIndentation", "rewrite", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "maxWidth", "wrapLineComments", "ktfmt"})
public final class KDocCommentsHelper
implements CommentsHelper {
    private final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX;
    private final String lineSeparator;
    private final int maxLineLength;

    @NotNull
    public String rewrite(@NotNull Input.Tok tok, int maxWidth, int column0) {
        Intrinsics.checkNotNullParameter((Object)tok, (String)"tok");
        if (!tok.isComment()) {
            String string = tok.getOriginalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tok.originalText");
            return string;
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            String string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            text = KDocFormatter.INSTANCE.formatKDoc(string, column0, this.maxLineLength);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator it = Newlines.lineIterator((String)text);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom((CharSequence)it.next()));
        }
        return tok.isSlashSlashComment() ? this.indentLineComments((List<String>)lines, column0) : (this.javadocShaped((List<String>)lines) ? this.indentJavadoc((List<String>)lines, column0) : this.preserveIndentation((List<String>)lines, column0));
    }

    private final String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn((CharSequence)lines.get(i));
            if (lineIdx >= 0 && (startCol == -1 || lineIdx < startCol)) {
                startCol = lineIdx;
            }
            ++i;
        }
        builder.append(lines.get(0));
        n2 = lines.size();
        for (i = 1; i < n2; ++i) {
            builder.append(this.lineSeparator).append(Strings.repeat((String)" ", (int)column0));
            if (lines.get(i).length() >= startCol) {
                String string = lines.get(i);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startCol);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                builder.append(string3);
                continue;
            }
            builder.append(lines.get(i));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String indentLineComments(List<String> lines, int column0) {
        List<String> lines2 = lines;
        lines2 = this.wrapLineComments(lines2, column0);
        StringBuilder builder = new StringBuilder();
        String string = lines2.get(0);
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        builder.append(((Object)StringsKt.trim((CharSequence)string2)).toString());
        String indentString = Strings.repeat((String)" ", (int)column0);
        n = 1;
        int n2 = lines2.size();
        while (n < n2) {
            void i;
            String string3 = lines2.get((int)i);
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            builder.append(this.lineSeparator).append(indentString).append(((Object)StringsKt.trim((CharSequence)string4)).toString());
            ++i;
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"builder.toString()");
        return string5;
    }

    private final List<String> wrapLineComments(List<String> lines, int column0) {
        ArrayList<String> result = new ArrayList<String>();
        for (String originalLine : lines) {
            int n;
            String string;
            String line2 = originalLine;
            Matcher matcher = this.LINE_COMMENT_MISSING_SPACE_PREFIX.matcher(line2);
            if (matcher.find()) {
                int length = matcher.group(1).length();
                StringBuilder stringBuilder = new StringBuilder().append(Strings.repeat((String)"/", (int)length)).append(" ");
                string = line2;
                n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(length);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                line2 = stringBuilder.append(string3).toString();
            }
            if (StringsKt.startsWith$default((String)line2, (String)"// MOE:", (boolean)false, (int)2, null)) {
                result.add(line2);
                continue;
            }
            while (line2.length() + column0 > 100) {
                int idx;
                for (idx = 100 - column0; idx >= 2 && !CharMatcher.whitespace().matches(line2.charAt(idx)); --idx) {
                }
                if (idx <= 2) break;
                string = line2;
                n = 0;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                result.add(string5);
                StringBuilder stringBuilder = new StringBuilder().append("//");
                string = line2;
                n = 0;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(idx);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                line2 = stringBuilder.append(string7).toString();
            }
            result.add(line2);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        String string = lines.get(0);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        builder.append(((Object)StringsKt.trim((CharSequence)string2)).toString());
        int indent = column0 + 1;
        String indentString = Strings.repeat((String)" ", (int)indent);
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            void i;
            builder.append(this.lineSeparator).append(indentString);
            String string3 = lines.get((int)i);
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String line2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            if (!StringsKt.startsWith$default((String)line2, (String)"*", (boolean)false, (int)2, null)) {
                builder.append("* ");
            }
            builder.append(line2);
            ++i;
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"builder.toString()");
        return string5;
    }

    private final boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String string = it.next();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String first = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (StringsKt.startsWith$default((String)first, (String)"/**", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!StringsKt.startsWith$default((String)first, (String)"/*", (boolean)false, (int)2, null)) {
            return false;
        }
        while (it.hasNext()) {
            string = it.next();
            bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (String)"*", (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    public KDocCommentsHelper(@NotNull String lineSeparator, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this.lineSeparator = lineSeparator;
        this.maxLineLength = maxLineLength;
        this.LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");
    }
}

