/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.EscapingKt;
import com.facebook.ktfmt.kdoc.KDocFormatter$WhenMappings;
import com.facebook.ktfmt.kdoc.KDocWriter;
import com.facebook.ktfmt.kdoc.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.lexer.KDocLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J&\u0010\u0018\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocFormatter;", "", "()V", "NUMBERED_LIST_PATTERN", "Lkotlin/text/Regex;", "ONE_CONTENT_LINE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "formatKDoc", "", "input", "blockIndent", "", "maxLineLength", "makeSingleLineIfPossible", "processToken", "", "tokenType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "tokens", "", "Lcom/facebook/ktfmt/kdoc/Token;", "tokenText", "previousType", "render", "", "tokenizeKdocText", "Lkotlin/sequences/Sequence;", "s", "ktfmt"})
public final class KDocFormatter {
    private static final Pattern ONE_CONTENT_LINE_PATTERN;
    private static final Regex NUMBERED_LIST_PATTERN;
    @NotNull
    public static final KDocFormatter INSTANCE;

    @NotNull
    public final String formatKDoc(@NotNull String input, int blockIndent, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String escapedInput = EscapingKt.escapeKDoc(input);
        KDocLexer kDocLexer = new KDocLexer();
        kDocLexer.start((CharSequence)escapedInput);
        boolean bl = false;
        List tokens = new ArrayList();
        IElementType previousType = null;
        while (kDocLexer.getTokenType() != null) {
            String string;
            IElementType tokenType = kDocLexer.getTokenType();
            String string2 = kDocLexer.getTokenText();
            boolean bl2 = false;
            boolean bl3 = false;
            String $this$with = string2;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)previousType, (Object)KDocTokens.LEADING_ASTERISK) && StringsKt.first((CharSequence)$this$with) == ' ') {
                String string3 = $this$with;
                int n = 1;
                boolean bl5 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                String string6 = $this$with;
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this");
            }
            String tokenText = string;
            this.processToken(tokenType, tokens, tokenText, previousType);
            previousType = tokenType;
            kDocLexer.advance();
        }
        String result = this.render(tokens, blockIndent, maxLineLength);
        return this.makeSingleLineIfPossible(blockIndent, result, maxLineLength);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processToken(IElementType tokenType, List<Token> tokens, String tokenText, IElementType previousType) {
        block16: {
            CharSequence charSequence;
            int count$iv;
            block17: {
                block15: {
                    IElementType iElementType = tokenType;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.START)) {
                        tokens.add(new Token(Token.Type.BEGIN_KDOC, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.END)) {
                        tokens.add(new Token(Token.Type.END_KDOC, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.LEADING_ASTERISK)) {
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.TAG_NAME)) {
                        tokens.add(new Token(Token.Type.TAG, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.CODE_BLOCK_TEXT)) {
                        tokens.add(new Token(Token.Type.CODE, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.MARKDOWN_INLINE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.MARKDOWN_LINK)) {
                        tokens.add(new Token(Token.Type.MARKDOWN_LINK, tokenText));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.TEXT)) break block15;
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.WHITE_SPACE)) throw (Throwable)new RuntimeException("Unexpected: " + tokenType);
                    if (Intrinsics.areEqual((Object)previousType, (Object)KDocTokens.LEADING_ASTERISK)) break block16;
                    CharSequence $this$count$iv = tokenText;
                    boolean $i$f$count = false;
                    count$iv = 0;
                    charSequence = $this$count$iv;
                    break block17;
                }
                boolean first = true;
                Iterator iterator = this.tokenizeKdocText(tokenText).iterator();
                while (iterator.hasNext()) {
                    String word;
                    block18: {
                        block20: {
                            block19: {
                                word = (String)iterator.next();
                                if (CharsKt.isWhitespace((char)StringsKt.first((CharSequence)word))) {
                                    tokens.add(new Token(Token.Type.WHITESPACE, " "));
                                    continue;
                                }
                                if (!first) break block18;
                                if (Intrinsics.areEqual((Object)word, (Object)"-") || Intrinsics.areEqual((Object)word, (Object)"*")) break block19;
                                CharSequence charSequence2 = word;
                                Regex regex = NUMBERED_LIST_PATTERN;
                                boolean bl = false;
                                if (!regex.matches(charSequence2)) break block20;
                            }
                            tokens.add(new Token(Token.Type.LIST_ITEM_OPEN_TAG, ""));
                        }
                        first = false;
                    }
                    if (Intrinsics.areEqual((Object)word, (Object)"*/")) {
                        tokens.add(new Token(Token.Type.END_KDOC, word));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)word, (Object)"```")) {
                        tokens.add(new Token(Token.Type.CODE_BLOCK_MARKER, word));
                        continue;
                    }
                    tokens.add(new Token(Token.Type.LITERAL, word));
                }
                return;
            }
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            if (count$iv < 2) {
                tokens.add(new Token(Token.Type.WHITESPACE, " "));
                return;
            }
        }
        tokens.add(new Token(Token.Type.BLANK_LINE, ""));
    }

    private final String render(List<Token> input, int blockIndent, int maxLineLength) {
        KDocWriter output2 = new KDocWriter(blockIndent, maxLineLength);
        block18: for (Token token : input) {
            switch (KDocFormatter$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
                case 1: {
                    output2.writeBeginJavadoc();
                    continue block18;
                }
                case 2: {
                    output2.writeEndJavadoc();
                    return EscapingKt.unescapeKDoc(output2.toString());
                }
                case 3: {
                    output2.writeListItemOpen(token);
                    continue block18;
                }
                case 4: {
                    output2.writePreOpen(token);
                    continue block18;
                }
                case 5: {
                    output2.writePreClose(token);
                    continue block18;
                }
                case 6: {
                    output2.writeCodeOpen(token);
                    continue block18;
                }
                case 7: {
                    output2.writeCodeClose(token);
                    continue block18;
                }
                case 8: {
                    output2.writeTableOpen(token);
                    continue block18;
                }
                case 9: {
                    output2.writeTableClose(token);
                    continue block18;
                }
                case 10: {
                    output2.writeTag(token);
                    continue block18;
                }
                case 11: {
                    output2.writeCodeLine(token);
                    continue block18;
                }
                case 12: {
                    output2.writeExplicitCodeBlockMarker(token);
                    continue block18;
                }
                case 13: {
                    output2.requestBlankLine();
                    continue block18;
                }
                case 14: {
                    output2.requestWhitespace();
                    continue block18;
                }
                case 15: {
                    output2.writeLiteral(token);
                    continue block18;
                }
                case 16: {
                    output2.writeMarkdownLink(token);
                    continue block18;
                }
            }
            throw (Throwable)((Object)new AssertionError((Object)token.getType()));
        }
        throw (Throwable)((Object)new AssertionError());
    }

    private final String makeSingleLineIfPossible(int blockIndent, String input, int maxLineLength) {
        int oneLinerContentLength = maxLineLength - "/**  */".length() - blockIndent;
        Matcher matcher = ONE_CONTENT_LINE_PATTERN.matcher(input);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return "/** */";
            }
        }
        if (matcher.matches() && matcher.group(1).length() <= oneLinerContentLength) {
            return "/** " + matcher.group(1) + " */";
        }
        return input;
    }

    @NotNull
    public final Sequence<String> tokenizeKdocText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(s, null){
            private /* synthetic */ Object L$0;
            int I$0;
            int I$1;
            int I$2;
            boolean Z$0;
            int label;
            final /* synthetic */ String $s;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = this.$s;
                        var4_6 = false;
                        if (var3_4.length() == 0) {
                            return Unit.INSTANCE;
                        }
                        mark = 0;
                        inWhitespace = CharsKt.isWhitespace((char)this.$s.charAt(0));
                        var5_7 = 1;
                        var6_9 = StringsKt.getLastIndex((CharSequence)this.$s);
                        if (var5_7 > var6_9) ** GOTO lbl53
lbl16:
                        // 2 sources

                        while (true) {
                            if (inWhitespace != CharsKt.isWhitespace((char)this.$s.charAt((int)i))) {
                                if (inWhitespace) {
                                    v0 = " ";
                                } else {
                                    var8_12 = this.$s;
                                    var9_13 = false;
                                    v1 = var8_12;
                                    if (v1 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v2 = v1.substring(mark, (int)i);
                                    v0 = v2;
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                }
                                result = v0;
                                inWhitespace = CharsKt.isWhitespace((char)this.$s.charAt(var5_7));
                                mark = var5_7;
                                this.L$0 = $this$sequence;
                                this.I$0 = mark;
                                this.Z$0 = inWhitespace;
                                this.I$1 = var5_7;
                                this.I$2 = var6_9;
                                this.label = 1;
                                v3 = $this$sequence.yield((Object)result, (Continuation)this);
                                if (v3 == var10_2) {
                                    return var10_2;
                                }
                            }
                            ** GOTO lbl50
                            break;
                        }
                    }
                    case 1: {
                        var6_9 = this.I$2;
                        var5_7 = this.I$1;
                        inWhitespace = this.Z$0;
                        mark = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl50:
                        // 2 sources

                        if (var5_7 != var6_9) {
                            ++var5_7;
                            ** continue;
                        }
lbl53:
                        // 3 sources

                        if (inWhitespace) {
                            v4 = " ";
                        } else {
                            var5_8 = this.$s;
                            var6_9 = this.$s.length();
                            var7_11 = false;
                            v5 = var5_8;
                            if (v5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v6 = v5.substring(mark, var6_9);
                            v4 = v6;
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        this.L$0 = null;
                        this.label = 2;
                        v7 = $this$sequence.yield((Object)v4, (Continuation)this);
                        if (v7 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl74
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl74:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$s = string;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private KDocFormatter() {
    }

    static {
        KDocFormatter kDocFormatter;
        INSTANCE = kDocFormatter = new KDocFormatter();
        ONE_CONTENT_LINE_PATTERN = Pattern.compile(" */[*][*]\n *[*] (.*)\n *[*]/");
        String string = "[0-9]+\\.";
        boolean bl = false;
        NUMBERED_LIST_PATTERN = new Regex(string);
    }
}

