/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt;

import com.facebook.ktfmt.FormatterKt;
import com.facebook.ktfmt.MainKt;
import com.facebook.ktfmt.ParseError;
import com.facebook.ktfmt.ParsedArgs;
import com.facebook.ktfmt.ParsedArgsKt;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/ktfmt/Main;", "", "input", "Ljava/io/InputStream;", "out", "Ljava/io/PrintStream;", "err", "args", "", "", "(Ljava/io/InputStream;Ljava/io/PrintStream;Ljava/io/PrintStream;[Ljava/lang/String;)V", "parsedArgs", "Lcom/facebook/ktfmt/ParsedArgs;", "format", "", "file", "Ljava/io/File;", "handleParseError", "", "fileName", "e", "Lcom/facebook/ktfmt/ParseError;", "run", "", "ktfmt"})
public final class Main {
    @NotNull
    private final InputStream input;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    @NotNull
    private final ParsedArgs parsedArgs;

    public Main(@NotNull InputStream input, @NotNull PrintStream out, @NotNull PrintStream err, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.input = input;
        this.out = out;
        this.err = err;
        this.parsedArgs = ParsedArgsKt.parseOptions(this.err, args);
    }

    public final int run() {
        if (this.parsedArgs.getFileNames().isEmpty()) {
            this.err.println("Usage: ktfmt [--dropbox-style | --google-style | --kotlinlang-style] File1.kt File2.kt ...");
            return 1;
        }
        if (this.parsedArgs.getFileNames().size() == 1 && Intrinsics.areEqual((Object)this.parsedArgs.getFileNames().get(0), (Object)"-")) {
            boolean success = this.format(null);
            return success ? 0 : 1;
        }
        List<File> files = null;
        try {
            files = MainKt.expandArgsToFileNames(this.parsedArgs.getFileNames());
        }
        catch (IllegalStateException e) {
            this.err.println(e.getMessage());
            return 1;
        }
        if (files.isEmpty()) {
            this.err.println("Error: no .kt files found");
            return 1;
        }
        AtomicBoolean success = new AtomicBoolean(true);
        files.parallelStream().forEach(arg_0 -> Main.run$lambda-0(success, this, arg_0));
        return success.get() ? 0 : 1;
    }

    private final boolean format(File file) {
        Object object;
        String string;
        File file2 = file;
        String fileName = string = file2 == null ? "<stdin>" : ((object = file2.toString()) == null ? "<stdin>" : object);
        try {
            object = file;
            file2 = object == null ? null : FilesKt.readText$default((File)object, null, (int)1, null);
            File code = file2 == null ? TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(this.input))) : file2;
            String formattedCode = FormatterKt.format(this.parsedArgs.getFormattingOptions(), (String)((Object)code));
            if (Intrinsics.areEqual((Object)code, (Object)formattedCode)) {
                this.err.println(Intrinsics.stringPlus((String)"No changes: ", (Object)fileName));
                return true;
            }
            if (this.parsedArgs.getDryRun()) {
                this.out.println(fileName);
            } else {
                if (file != null) {
                    FilesKt.writeText$default((File)file, (String)formattedCode, null, (int)2, null);
                } else {
                    this.out.print(formattedCode);
                }
                this.err.println(Intrinsics.stringPlus((String)"Done formatting ", (Object)fileName));
            }
            return !this.parsedArgs.getSetExitIfChanged();
        }
        catch (IOException e) {
            this.err.println("Error formatting " + fileName + ": " + e.getMessage() + "; skipping.");
        }
        catch (ParseError e) {
            this.handleParseError(fileName, e);
        }
        catch (FormattingError e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                System.err.println(fileName + ':' + diagnostic);
            }
            e.printStackTrace(this.err);
        }
        return false;
    }

    private final void handleParseError(String fileName, ParseError e) {
        this.err.println(fileName + ':' + e.getMessage());
    }

    private static final void run$lambda-0(AtomicBoolean $success, Main this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)$success, (String)"$success");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $success.compareAndSet(true, this$0.format(it));
    }
}

