/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt;

import com.facebook.ktfmt.FormatterKt;
import com.facebook.ktfmt.FormattingOptions;
import com.facebook.ktfmt.KotlinInput;
import com.facebook.ktfmt.KotlinInputAstVisitorBase;
import com.facebook.ktfmt.ParseError;
import com.facebook.ktfmt.Parser;
import com.facebook.ktfmt.RedundantElementRemover;
import com.facebook.ktfmt.WhitespaceTombstonesKt;
import com.facebook.ktfmt.debughelpers.OpsDebugKt;
import com.facebook.ktfmt.kdoc.EscapingKt;
import com.facebook.ktfmt.kdoc.KDocCommentsHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DEFAULT_MAX_WIDTH", "", "DROPBOX_FORMAT", "Lcom/facebook/ktfmt/FormattingOptions;", "GOOGLE_FORMAT", "KOTLINLANG_FORMAT", "checkEscapeSequences", "", "code", "", "createAstVisitor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElementVisitor;", "options", "builder", "Lcom/google/googlejavaformat/OpsBuilder;", "format", "removeUnusedImports", "", "prettyPrint", "lineSeparator", "sortedAndDistinctImports", "ktfmt"})
public final class FormatterKt {
    public static final int DEFAULT_MAX_WIDTH = 100;
    @JvmField
    @NotNull
    public static final FormattingOptions GOOGLE_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 2, 2, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions KOTLINLANG_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 4, 4, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions DROPBOX_FORMAT = new FormattingOptions(FormattingOptions.Style.DROPBOX, 0, 4, 4, false, false, 50, null);

    @NotNull
    public static final String format(@NotNull String code) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return FormatterKt.format(new FormattingOptions(null, 0, 0, 0, false, false, 63, null), code);
    }

    @NotNull
    public static final String format(@NotNull String code, boolean removeUnusedImports) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return FormatterKt.format(new FormattingOptions(null, 0, 0, 0, removeUnusedImports, false, 47, null), code);
    }

    @NotNull
    public static final String format(@NotNull FormattingOptions options, @NotNull String code) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        FormatterKt.checkEscapeSequences(code);
        String string = StringUtilRt.convertLineSeparators((String)code);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(code)");
        String lfCode = string;
        String sortedImports = FormatterKt.sortedAndDistinctImports(lfCode);
        String pretty = FormatterKt.prettyPrint(sortedImports, options, "\n");
        String noRedundantElements = RedundantElementRemover.INSTANCE.dropRedundantElements(pretty, options);
        String string2 = Newlines.guessLineSeparator((String)code);
        Intrinsics.checkNotNull((Object)string2);
        return FormatterKt.prettyPrint(noRedundantElements, options, string2);
    }

    private static final String prettyPrint(String code, FormattingOptions options, String lineSeparator) {
        KtFile file = Parser.Companion.parse(code);
        KotlinInput kotlinInput = new KotlinInput(code, file);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, (Input)kotlinInput, (CommentsHelper)new KDocCommentsHelper(lineSeparator, options.getMaxWidth()));
        OpsBuilder builder = new OpsBuilder((Input)kotlinInput, (Output)javaOutput);
        file.accept(FormatterKt.createAstVisitor(options, builder));
        builder.sync(kotlinInput.getText().length());
        builder.drain();
        ImmutableList ops = builder.build();
        if (options.getDebuggingPrintOpsAfterFormatting()) {
            Intrinsics.checkNotNullExpressionValue((Object)ops, (String)"ops");
            OpsDebugKt.printOps((ImmutableList<Op>)ops);
        }
        Doc doc = new DocBuilder().withOps((List)ops).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.getMaxWidth(), new Doc.State(0, 0));
        doc.write((Output)javaOutput);
        javaOutput.flush();
        Object object = ImmutableList.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(code.length())));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"of(Range.closedOpen(0, code.length))");
        RangeSet<Integer> tokenRangeSet = kotlinInput.characterRangesToTokenRanges((Collection)object);
        object = JavaOutput.applyReplacements((String)code, (List)((List)javaOutput.getFormatReplacements(tokenRangeSet)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applyReplacements(code, javaOutput.getFormatReplacements(tokenRangeSet))");
        return WhitespaceTombstonesKt.replaceTombstoneWithTrailingWhitespace((String)object);
    }

    @NotNull
    public static final PsiElementVisitor createAstVisitor(@NotNull FormattingOptions options, @NotNull OpsBuilder builder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (KotlinVersion.CURRENT.getMajor() == 1 && KotlinVersion.CURRENT.getMinor() == 4) {
            string = "com.facebook.ktfmt.Kotlin14InputAstVisitor";
        } else if (KotlinVersion.CURRENT.getMajor() == 1 && KotlinVersion.CURRENT.getMinor() == 5) {
            string = "com.facebook.ktfmt.Kotlin15InputAstVisitor";
        } else if (KotlinVersion.CURRENT.getMajor() == 1 && KotlinVersion.CURRENT.getMinor() == 6) {
            string = "com.facebook.ktfmt.Kotlin15InputAstVisitor";
        } else {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported runtime Kotlin version: ", (Object)KotlinVersion.CURRENT));
        }
        String visitorClassName = string;
        Object[] objectArray = new Class[]{FormattingOptions.class, OpsBuilder.class};
        Constructor<KotlinInputAstVisitorBase> constructor = Class.forName(visitorClassName).asSubclass(KotlinInputAstVisitorBase.class).getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{options, builder};
        KotlinInputAstVisitorBase kotlinInputAstVisitorBase = constructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kotlinInputAstVisitorBase), (String)"forName(visitorClassName)\n      .asSubclass(KotlinInputAstVisitorBase::class.java)\n      .getConstructor(FormattingOptions::class.java, OpsBuilder::class.java)\n      .newInstance(options, builder)");
        return (PsiElementVisitor)kotlinInputAstVisitorBase;
    }

    private static final void checkEscapeSequences(String code) {
        int index = WhitespaceTombstonesKt.indexOfWhitespaceTombstone(code);
        if (index == -1) {
            index = EscapingKt.indexOfCommentEscapeSequences(code);
        }
        if (index != -1) {
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(code, index)");
            throw new ParseError("ktfmt does not support code which contains one of {\\u0003, \\u0004, \\u0005} character; escape it", lineColumn);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sortedAndDistinctImports(@NotNull String code) {
        void $this$distinctBy$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        KtFile file = Parser.Companion.parse(code);
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null) {
            return code;
        }
        KtImportList importList = ktImportList;
        if (importList.getImports().isEmpty()) {
            return code;
        }
        PsiElement nonImportElement = FormatterKt.sortedAndDistinctImports$findNonImportElement(importList);
        if (nonImportElement != null) {
            String string = Intrinsics.stringPlus((String)"Imports not contiguous (perhaps a comment separates them?): ", (Object)nonImportElement.getText());
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)PsiUtilsKt.getStartOffset((PsiElement)nonImportElement));
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(code, nonImportElement.startOffset)");
            throw new ParseError(string, lineColumn);
        }
        Object object = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importList.imports");
        Iterable $this$sortedBy$iv = (Iterable)object;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                KtImportDirective p0 = (KtImportDirective)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)FormatterKt.access$sortedAndDistinctImports$canonicalText(p0));
                p0 = (KtImportDirective)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = FormatterKt.access$sortedAndDistinctImports$canonicalText(p0);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtImportDirective p0 = (KtImportDirective)e$iv;
            boolean bl2 = false;
            String key$iv = FormatterKt.sortedAndDistinctImports$canonicalText(p0);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sortedImports = list$iv;
        object = code;
        int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)importList));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
        CharSequence charSequence = Intrinsics.stringPlus((String)CollectionsKt.joinToString$default((Iterable)sortedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)sortedAndDistinctImports.1.INSTANCE, (int)30, null), (Object)"\n");
        boolean bl3 = false;
        return ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)object), (int)n, (int)n2, (CharSequence)charSequence)).toString();
    }

    private static final PsiElement sortedAndDistinctImports$findNonImportElement(KtImportList importList) {
        for (PsiElement element = importList.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof KtImportDirective || element instanceof PsiWhiteSpace) continue;
            return element;
        }
        return null;
    }

    private static final String sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        String string;
        FqName fqName = importDirective.getImportedFqName();
        return (fqName == null ? null : fqName.asString()) + ' ' + ((fqName = importDirective.getAlias()) == null ? null : ((string = fqName.getText()) == null ? null : StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null))) + ' ' + (importDirective.isAllUnder() ? "*" : "");
    }

    public static final /* synthetic */ String access$sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        return FormatterKt.sortedAndDistinctImports$canonicalText(importDirective);
    }
}

